<?php
#=
/****************************************************************************
Copyright 2002, Daniel Deycard, Jacques Messines, Alain Pomirol
(CATICE Acadmie de Bordeaux)

This file is part of GiBii/Melia.

GiBii/Melia is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

GiBii/Melia is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GiBii/Melia; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/
include("../include/vars_adm.php");
include("../include/util.inc.php");
include("../include/utiljs.php");
include("../include/purges.inc.php");
include("../include/suppr.inc.php");
include("../sadmin/table_verifs.inc.php");
include("../sadmin/verifs.inc.php");

set_time_limit(300);
connecte($host,$user,$mdp,$db);
opensession('Sadmin',false);
if ($sess_login=='admstats') {
	aneantir_session();
	goto("./index.php");
	}
?>
<HTML>

<HEAD>
<meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
<TITLE>nom1</TITLE>
<BASE TARGET="_self">
<link rel="stylesheet" href="../include/general.css">
</HEAD>
<body class="arial_sadmin">

<?php


    //fonctions annexes (de second niveau ou plus)
    //===========================================
    function supp_lec($sql) {
        $nb=0;
        $res=query($sql);
        while (list($e,$c)=mysql_fetch_array($res)) {
            query("DELETE FROM lien_eleves_classes WHERE eleve_id=$e and classe_id=$c");
            $nb++;
            }
        mysql_free_result($res);
        return $nb;
        }


    //fin fonctions de second niveau
    //==============================


//***********************************************************
//fonctions appeles par $param() dans le programme principal
//***********************************************************

//______________________________________________________________________________

function quotes() {
    //nettoie les \' de la base.
    //pour une raison inconnue  ce jour 05/08/2005, certains noms ou prnoms
    //contenant des apostrophes sont (ou sont devenus) inaccessibles, peut-tre  la
    //suite d'un changement de magic_quotes.
    //inaccessible signifie que SELECT ... WHERE nom='M\'BOLO' ne sera pas trouv
    //alors qu'il sera dans SELECT ... WHERE nom LIKE 'M%'.
    //Ce script les rgnre. Allez donc savoir pourquoi... !
    print "<p class=\"titre\" align=\"center\">
            Vrification des quotes
           </p><hr width=\"30%\">";

    print "<center><table border=\"1\" cellpadding=\"5\"><tr><th>Table</th><th>Champ</th><th>nombre de modifications</th></tr>\n";

    $liste=array('eleves'           => array('nom','prenom'),
                 'profs'            => array('nom','prenom'),
                 'etablissements'   => array('nom','adresse','ville'),
                 'demandes'         => array('commentaire'),
                 'reponses'         => array('commentaire'),
                 'comptes'          => array('login')
                 );

    foreach ($liste as $table => $champs) {
        foreach ($champs as $champ) {
            print "<tr><td> <b> $table </b> </td>\n";
            print "<td> $champ </td>\n";
            //remplacer \' par '
            query("UPDATE $table SET $champ = REPLACE($champ,'\\\\\\'','\\'') WHERE $champ LIKE '%\\\\\\'%';");
            $nb=mysql_affected_rows();
            //replacer les \ terminaux par ' (un jour, il a d y avoir un chane qui a t coupe en plein milieu de \')
            query("UPDATE $table SET $champ = REPLACE($champ,'\\\\','\\'') WHERE $champ LIKE '%\\\\'");
            $nb+=mysql_affected_rows();
            print "<td align=\"center\">$nb</td>";
            print "</tr>\n";
            }
        }
    print "</table></center>\n";
    return true;
}


//______________________________________________________________________________

function comptes_individus($tabledep) {
    include("../sadmin/verif_comptes.php");
    print "<form name=\"formc\" method=\"post\" action=\"verif_comptes_traite.php\">\n";
    $call='verif_'.$tabledep;
    list($sce,$mode)=$call('eleve');         // partir d'un compte ou d'un user, cherche l'user ou le compte
    list($scp,$modp)=$call('prof');
    $totalsupp=$scp+$sce;
    $totalmod=$mode || $modp;
    $plue=pluriel($sce);$plup=pluriel($scp);$plu=pluriel($totalsupp);
    if ($totalsupp) {
        print "<p><b>$totalsupp compte$plu supprim$plu :
                     $sce compte$plue lve$plue,
                     $scp compte$plup prof$plup.";
        }
    if ($totalmod) {
        print "<p align=\"center\">\n";
        submit_bouton('traiter_verif','Effectuer les traitements conseills',true);
        print "</form>";
        print "<br /><br />";
        print "<a href=\"../sadmin/choix_verif.form.php\">
                Ne rien faire et revenir au menu &laquo;Vrifications&raquo;
               </a>";
        print "</p>\n";
        return false;
        }
    else {
        print "</form>";
        print "<p align = \"center\">Pas de cas  corriger manuellement</p>";
        return true; //pour afficher un bouton de reour au menu
        }
    }

//______________________________________________________________________________

function comptes()   {
    print "<p class=\"titre\" align=\"center\">Vrification des comptes</p><hr width=\"30%\">";
    return comptes_individus('comptes');
    }

//______________________________________________________________________________
function individus() {
    print "<p class=\"titre\" align=\"center\">Vrification des tables eleves et profs</p><hr width=\"30%\">";
    return comptes_individus('users');
    }

//______________________________________________________________________________

function rep_orph() {
    //rponses enterres (perdues)
    //----------------------------
    $res=query("SELECT reponse_id FROM reponses
                  LEFT  JOIN demandes ON demandes.message_id = reponses.message_id
                 WHERE demandes.message_id IS NULL");
    $liste='';
    $nbrperdues=0;
    while (list($rid)=mysql_fetch_array($res)) {
        $liste.=','.$rid;
        $nbrperdues++;
        }
    if ($liste) {
        $liste='('.substr($liste,1).')';
        query("DELETE FROM reponses WHERE reponse_id IN $liste");
        print "<h3>Rponses perdues (sans demande associe)</h3>";
        print str_replace(',',' - ',$liste);
        }
    mysql_free_result($res);
    return true;
    }

//______________________________________________________________________________

function dem_orph() {
     print "<p class=\"titre\" align=\"center\">
            Demandes orphelines
           </p><hr width=\"30%\">";
    $tab=str_repeat("&nbsp;",5);

    //Visite table demandes pour chercher les orphelins
    $sql_demandes = 'SELECT demandes.message_id
                       FROM demandes
                       LEFT JOIN eleves
                       ON eleves.eleve_id=demandes.eleve_id
                       WHERE eleves.eleve_id IS NULL';
    $demandes = query($sql_demandes);
    print "<center><table border = \"0\" width = \"80%\"> <tr><td align = \"center\"><br /><u> Demandes orphelines</u> : ";
    $nbdem=0;
    $liste=array();
    while (list($demid)=mysql_fetch_array($demandes)) {
        print "$demid $tab";
        $liste[]=$demid;
        $nbdem++;
        }
	purge_demrep($liste);
    $plu=pluriel($nbdem);
    print "$tab $nbdem demande$plu supprime$plu<br />";
    print "<br /></td></tr></table></center>";

    //Visite table rsultats pour chercher les orphelins
    $sql_result = 'SELECT resultats.resultat_id
                    FROM resultats
                    LEFT JOIN eleves
                    ON resultats.eleve_id=eleves.eleve_id
                    WHERE eleves.eleve_id IS NULL';
    $result = query($sql_result);
    print "<center><table border = \"0\" width = \"80%\"> <tr><td align = \"center\"><br /><br /><u> Rsultats orphelins</u> : ";
    $nbresultats=0;
    while (list($resid)=mysql_fetch_array($result)) {
        print "$resid $tab";
        suppr_resultat($resid); 
        $nbresultats++;
        }
    $plur=pluriel($nbresultats);
    print "$tab $nbresultats rsultat$plur supprim$plur";
    print "<br /></td></tr></table></center>";
    return true;
    }

function lien_profs() {
    print "<p class=\"titre\" align=\"center\">
        	Liens profs orphelins
       		</p><hr width=\"30%\">";
    $tab=str_repeat("&nbsp;",5);
    //Visite table lpi pour chercher des orphelins
    $sql_profs = 'SELECT lpi.prof_id
                    FROM lpi
                    LEFT JOIN profs
                    ON lpi.prof_id=profs.prof_id
                    WHERE profs.prof_id IS NULL';
    $result = query($sql_profs);
    print "<center><table><tr><td>\n";
    print "<br><u> Liens profs_items orphelins :</u>";
    while (list($profid)=mysql_fetch_array($result)) {
            query("DELETE FROM lpi WHERE prof_id=$profid");
            print "<br>$tab Enregistrement $profid supprim";
            }
    //Visite table lien_profs_classes pour chercher des orphelins
    $sql_profs = 'SELECT lien_profs_classes.prof_id
                FROM lien_profs_classes
                LEFT JOIN profs
                ON lien_profs_classes.prof_id=profs.prof_id
                WHERE profs.prof_id IS NULL';
    $result = query($sql_profs);
    print "<br><u> Liens profs_classes orphelins :</u>";
    while (list($profid)=mysql_fetch_array($result)) {
            query("DELETE FROM lien_profs_classes WHERE prof_id=$profid");
            print "<br>$tab Enregistrement $profid supprim";
            }
    print "<br><br>Nettoyage profs termin.";
    print "</td></tr></table></center>\n";
    return true;
    }

//______________________________________________________________________________

function lien_resultats() {
    print "<p class=\"titre\" align=\"center\">
            Vrification de la table lrp (liens rsultats profs)
           </p><hr width=\"30%\"><br />";

	return true;	
}


//______________________________________________________________________________

function lien_eleves() {
    print "<p class=\"titre\" align=\"center\">
            Vrification de la table lien_eleves_classes
           </p><hr width=\"30%\"><br />";
    //supprime dans lien_eleves_classes les lignes (e,c) inutiles :

    print "<center> <table border=\"1\" cellpadding=\"10\">";

    //1) cohrences classes : vrifie que l'lve a bien c pour classe_id
    //----------
    $nb=supp_lec("SELECT lien_eleves_classes.eleve_id,lien_eleves_classes.classe_id
                    FROM  lien_eleves_classes,eleves,classes
                    WHERE lien_eleves_classes.eleve_id=eleves.eleve_id
                    AND   lien_eleves_classes.classe_id=classes.classe_id
                    AND   classes.divgro='D'
                    AND   lien_eleves_classes.classe_id<>eleves.classe_id");
    print "<tr><td> couples (lve,classe) avec <b>'lve' qui n'est pas dans 'classe'</b> </td>\n";
    print "<td align=\"center\"> $nb </td>";
    print "</tr>\n";

    //2) eleve inexistant
    //---------
    $nb=supp_lec("SELECT lien_eleves_classes.eleve_id,lien_eleves_classes.classe_id
                    FROM lien_eleves_classes
                    LEFT  JOIN eleves
                    ON lien_eleves_classes.eleve_id = eleves.eleve_id
                    WHERE eleves.eleve_id IS  NULL");
    print "<tr><td>  couples (lve,classe) avec <b>'lve' disparu </b> </td>\n";
    print "<td align=\"center\"> $nb </td>";
    print "</tr>\n";

    //3) classe inexistante
    //----------
    $nb=supp_lec("SELECT lien_eleves_classes.eleve_id,lien_eleves_classes.classe_id
                    FROM lien_eleves_classes
                    LEFT  JOIN classes ON lien_eleves_classes.classe_id = classes.classe_id
                    WHERE classes.classe_id IS NULL");
    print "<tr><td> couples (lve,classe) avec <b>'classe' inexistante</b> </td>\n";
    print "<td align=\"center\"> $nb </td>";
    print "</tr>\n";

    //4) couples (e,c) qui doublonnent
    //----------
    $res=query("SELECT eleve_id,classe_id, count(eleve_id) nbdoublons
                FROM lien_eleves_classes
                GROUP BY eleve_id,classe_id
                HAVING nbdoublons>1");
    $nb=0; //compte les "classes" de doublons
    while (list($eleve_id,$classe_id,$nbdoublons)=mysql_fetch_array($res)) {
           $nb++;
          //tous les supprimer
          query("DELETE FROM lien_eleves_classes
                    WHERE eleve_id=$eleve_id AND classe_id=$classe_id");
          //en remettre UN :
          query("INSERT INTO lien_eleves_classes
                    SET eleve_id=$eleve_id, classe_id=$classe_id");
         }
    print "<tr><td> couples (lve,classe) enregistrs plusieurs fois <b>(doublons)</b></td>\n";
    print "<td align=\"center\"> $nb </td>";
    print "</tr>\n";

    //5) couples (e,c) qui manquent pour les lves de l'anne en cours
    //----------
    //chercher les lves de l'anne dont la classe n'est pas recense dans lien_eleves_classes
    //Pour les cas trouvs, enregistrer le rsultat dans la table liens
    $res=query("SELECT eleves.eleve_id,eleves.classe_id
                FROM eleves
                LEFT JOIN lien_eleves_classes
                ON eleves.eleve_id = lien_eleves_classes.eleve_id
                    AND eleves.classe_id = lien_eleves_classes.classe_id
                WHERE lien_eleves_classes.classe_id IS NULL
                    AND eleves.tag=0
                    AND eleves.annee=".ascol());
    $nb=mysql_num_rows($res);
    while (list($eleve_id,$classe_id)=mysql_fetch_array($res)) {
        query("INSERT INTO lien_eleves_classes SET eleve_id=$eleve_id, classe_id=$classe_id");
        }
    print "<tr><td> couples (lve,classe) <b>absents </b> </td>\n";
    print "<td align=\"center\"> $nb </td>";
    print "</tr>\n";


    print "</table></center>\n";


    mysql_free_result($res);
    return true;
    }

//______________________________________________________________________________

function classes_inutiles() {

    //1) classes inutiles
    //----------------
    print "<p class=\"titre\" align=\"center\">
        Classes inutiles
       </p><hr width=\"30%\">";
    $tab=str_repeat("&nbsp;",5);

    $res=query("SELECT classes.classe_id
                FROM classes
           LEFT JOIN lien_eleves_classes ON classes.classe_id = lien_eleves_classes.classe_id
           LEFT JOIN lien_profs_classes ON classes.classe_id = lien_profs_classes.classe_id
           WHERE     lien_eleves_classes.eleve_id IS NULL
           AND       lien_profs_classes.prof_id IS NULL
           AND       classes.divcod='D'");
    $liste='';
    while (list($classe_id)=mysql_fetch_array($res)) $liste.=','.$classe_id;
    mysql_free_result($res);
    if ($liste) {
        $liste='('.substr($liste,1).')';
        query("DELETE FROM classes WHERE classe_id IN $liste");
        $nb=mysql_affected_rows();
        }
    else $nb=0;
    $plu=pluriel($nb);
    print "<p align = \"center\">\n";
    print "Classe$plu inutile$plu supprime$plu :$tab $nb";
    print "</p>\n";
    return true;
}

//______________________________________________________________________________

function classes_perdues() {
    print "<p class=\"titre\" align=\"center\">
            Classes perdues
          </p><hr width=\"30%\">";
    $tab=str_repeat("&nbsp;",5);
    //2) classes perdues ou supprimes indment alors qu'il existe encore des lves de l'anne
    //------------------
    $res=query("SELECT DISTINCT eleves.classe_id, eleves.etab_id
                  FROM    eleves
                LEFT JOIN classes
                ON        eleves.classe_id=classes.classe_id
                WHERE     classes.classe_id IS NULL
                  AND     eleves.annee=".ascol());
    $nb=0;
    print "<p>\n";
    while (list($classe_id,$etab_id)=mysql_fetch_array($res)) {
        //il faut inventer des noms de classes. On utilise l'ancien id
        $nomclasse="LOST-$etab_id-$classe_id";
        $nb++;
        query("INSERT INTO classes SET divcod='$nomclasse',
                                       divgro='D',
                                       etab_id=$etab_id");
        $new_classe_id=mysql_insert_id();
        //tous les lves de la classe perdue "changent" de classe
        query("UPDATE eleves SET classe_id=$new_classe_id WHERE classe_id=$classe_id");
        printf (" - %s (%d lves) ",$nomclasse,mysql_affected_rows());
        //un update de lien_eleves_classes n'est pas suffisants (cas des liens perdus)
        //donc on fait laborieusement
        //query("UPDATE lien_eleves_classes SET classe_id=$new_classe_id WHERE classe_id=$classe_id");
        //on supprime les scories de l'ancienne classe perdue
        query("DELETE FROM lien_eleves_classes WHERE classe_id=$classe_id");
        //on rtablit les liens avec le nouveau numro en cherchant les lves concerns
        $res=query("SELECT eleves.eleve_id
                      FROM eleves
                 LEFT JOIN lien_eleves_classes
                        ON eleves.eleve_id=lien_eleves_classes.eleve_id
                     WHERE lien_eleves_classes.classe_id IS NULL
                       AND eleves.classe_id=$new_classe_id
                       AND eleves.tag=0
                       AND eleves.annee=".ascol());
        while (list($eleve_id)=mysql_fetch_array($res)) {
            query("INSERT INTO lien_eleves_classes SET eleve_id=$eleve_id, classe_id=$new_classe_id");
            }
        }
    print "</p>";
    $plu=pluriel($nb);
    print "<p align = \"center\">\n";
    print "Classe$plu perdue$plu et rcupre$plu : $nb";
    print "</p>\n";
    return true;
    }

//______________________________________________________________________________

function classes_aux_noms_vides() {
$res=query("SELECT classe_id,etab_id FROM classes WHERE divcod=''");
$nb=mysql_num_rows($res);
while (list($classe_id,$etab_id)=mysql_num_rows($res)) {
    query("UPDATE classes SET divcod='SansNom_$etab_id' WHERE classe_id=$classe_id");
    }
print "<tr><td> classes dont le nom est vide</b> </td>\n";
print "<td align=\"center\"> $nb </td>";
print "</tr>\n";
mysql_free_result($res);
return true;
}

//______________________________________________________________________________

function dedoublonne_resultats() {
dedoub_resultats(true); //affichage des rsultats dans la page
return true;
}

//______________________________________________________________________________


/******************************************************************************/
//                       PROGRAMME PRINCIPAL
/******************************************************************************/
//traite toutes les vrifications  base de fonctions
//(lorsque l'indice 'suite' vaut 'fonction' ou n'est pas dfini)

//$choix est rcupr par GET
if (isset($verif[$choix])) $ret=$choix();
else print "<h3>Choix inconnu.</h3>";

if ($ret) retour("../sadmin/choix_verif.form.php");
?>

</body></html>