<?php
   require_once "../lib/artichow/LinePlot.class.php";
   
   $graph = new Graph(800, 400);
   $graph->setAntiAliasing(TRUE);
   
  $titre=urldecode($_GET['titre'])." (nb items valids)";
  $index = explode(',',urldecode($_GET['index']));
  $nombre= explode(',',urldecode($_GET['nombre']));	
  
   $plot = new LinePlot($nombre);
   $plot->setBackgroundColor(new Color(240, 240, 240));
   
   $plot->hideLine(TRUE);
   $plot->setFillColor(new Color(140, 180, 110, 50));
   
   $plot->grid->setBackgroundColor(new Color(235, 210, 80, 80));
   
   //$plot->yAxis->setLabelPrecision(2);

   $plot->xAxis->setLabelText($index);
   $plot->xAxis->title->set("Disciplines reprsentes"); 
   $plot->yAxis->title->set("Nombre de validations par discipline");  
   $plot->yAxis->setTitlePosition(0.65);   
   $plot->yAxis->setLabelPrecision(0);
      
   $plot->setSpace(6, 6, 10, 10);
   
   $plot->mark->setType(MARK_IMAGE);
   $plot->mark->setImage(new FileImage("../lib/artichow/images/star.png"));
   
   $plot->label->set($nombre);
   $plot->label->move(5, -23);
   $plot->label->setBackgroundGradient(
      new LinearGradient(
         new Color(185, 200, 150, 30),
         new Color(250, 250, 250, 10),
         0
      )
   );
   $plot->label->border->setColor(new Color(160, 180, 120, 20));
   $plot->label->setPadding(3, 1, 1, 2);
   
   $graph->add($plot);
   $graph->draw();
   
?>
