<?php
#=
/****************************************************************************
Copyright 2002, Daniel Deycard, Jacques Messines, Alain Pomirol
(CATICE Acadmie de Bordeaux)

This file is part of Gibii.

Gibii is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Gibii is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Gibii; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/

//en variables de session :
// $inceleves contient 0 ou 1 (fichier eleves.txt  traiter)
// $incprofs  contient 0 ou 1 (fichier profs.txt  traiter)

// $fichier contient le fichier des individus de la nouvelle anne




include("../include/vars_adm.php");
include("../include/util.inc.php");
include("../incorporation/individus.class.php");
include("../incorporation/importation.php");
include("../include/utiljs.php");
include("./enluminures.inc.php");

function errtxt(&$quidam,$fichier) {
print "<p style=\"color: Red\">";
print "Fichier $fichier. Problme avec la ligne d'en-tte.";
print "</p><p>";
print implode(" ; ",$quidam->entete);
print "</p><p>";
print get_errmsg($quidam->codemap);
//afficher complment ventuel de message
if ($quidam->msgerreur) print " [".$quidam->msgerreur."]";
print ".\n</p>";
}

function affmappage($elvprof,$fichier) {
//affiche un tableau de mappage  valider par l'admin
//retourne true si les champs n'ont pas d'incohrence
$nouveau=getprotomap($elvprof,$fichier);  //dans importation.php
if ($nouveau->codemap<0) {
	errtxt($nouveau,$fichier);
	return false;
	}
//afficher la ligne d'en-tte
$ligne1=$ligne2=$ligne3='';
foreach($nouveau->map as $gibii=>$rang) {
	if ($nouveau->codemap==1) {
		if (isset($nouveau->entete[$rang])) $ett=$nouveau->entete[$rang];
		else $ett="&nbsp;";
		$ligne1.="<td><b>&nbsp;$ett&nbsp;</b></td>";
		}
	$ligne2.="<td>&nbsp;$gibii&nbsp;</td>";
	}
print "<table width=\"90%\" border=\"1\" style=\"font-size: smaller;\" >\n";
if ($nouveau->codemap==1) print "<tr><td><b>En-tte</b></td>$ligne1</tr>\n";
print "<tr><td>Nom interne</td>&nbsp;$ligne2&nbsp;</tr>\n";

//les 3 premires lignes de donnes du fichier texte
for ($i=0 ; $i<count($nouveau->exemples) ; $i++) {
	$ligne=$nouveau->exemples[$i];
	$liste=explode($nouveau->sep,$ligne);
	print "<tr><td>Exemple ".($i+1)."</td>";
	foreach($nouveau->map as $gibii=>$rang) {
		print "<td>&nbsp;";
		if (isset($liste[$rang]) && $elem=trim($liste[$rang])) 
			; //rien ! 
		else $elem="&nbsp;";
		print $elem;
		print "&nbsp;</td>";
		}
	print "</tr>\n";
	}
print "</table>\n";
return true;
}

//##########################################################################
//on vient avec var de sess incoreleves=0/1 et incorprofs=0/1
//les noms des fichiers sont dans fichiereleves et/ou fichierprofs
//purgefic, razlogin, razmdp sont mises en session par le script prcdent


opensession("Admin",false);
set_time_limit(0);
connecte($host,$user,$mdp,$db);
$pathimages="./images";
$texte="PATIENCE";
entete("Importation d'utilisateurs");

//Vrification des en-ttes (pas de demande d'accord en mode batch)
//verif_entete=1 au premier passage en mode manuel et n'est pas dfinie dans les autres cas.
//print_r($_REQUEST);
if (isset($verif_entete) && $verif_entete==1) {
	$result_e=$result_p=true;
	//$verif_entete++;
	print "<h2><b>Correspondances entre l'en-tte fichier et les noms internes attendus</b></h2>";	
	if ($incoreleves) {
		print "<b>Elves</b>\n";
		$result_e=affmappage('eleve',$fichiereleves); 
		}
	if ($incorprofs)  {
		print "<b>Profs</b>\n";
		$result_p=affmappage('prof',$fichierprofs);
		}

	print "</div>\n";
	if ($result_e && $result_p) {
		//sinon, on demande  l'admin de confirmer les en-ttes trouvs.	
		?>
		<p><br /><b><i>Vrifiez que le ou les fichiers textes ont t analyss correctement.</i></b></p>
		<p style="text-align: center;">
		<form method="POST" action="txt2tables.php" target="_self" name="verif">
		<input type="submit" name="exec" value="Continuer le traitement" accesskey="c" tabindex="1" />
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		<input type="hidden" name="verif_entete" value="0" />
		<input type="button" value="Stopper" accesskey="a" tabindex="2" title="Utilisez ce bouton si vous hsitez sur l'en-tte trouve par GiSCCo" onclick="this.form.action='upload_txt_dbf.php';this.form.submit();return true;" />
		</form>
		<?php
		}
	else retour("./upload_txt_dbf.php");
	print '</body></html>';
	exit();
	}

//en-tte correct et confirm. On lit et enregistre les donnes du fichier
$pathimages="./images";
$texte="PATIENCE";
print "<p style=\"text-align: center\">";
$hints=array('Allez...','...voir...','...le...','...lien...','...tout...','......','...la...','...fin !');
for ($i=0;$i<strlen($texte);$i++)
     print "<img src=\"$pathimages/".substr($texte,$i,1).".gif\"  alt=\"$hints[$i]\" border=0>\n";
print "<br><br></p>";
//initialisations des variables affectes sous conditions plus bas
$nbincertains_e=$nbtraites_e=0;
$nbincertains_p=$nbtraites_p=0;

//2 variables sont ncessaires pour les fonctions qui suivront : $masque et $champactif
//elles sont globales mais pas en session
if ($IMPOSE_CHGT_MDP) $champactif=0; else $champactif=1;

//virer les anciens incertains, dans divers et dans eleves/profs

if ($incoreleves) {
    query("DELETE FROM eleves WHERE (tag>=1 OR compte_id IS NULL) 
			AND etab_id=$etab_id"); //anciens incertains qui trainent
	if (table_dans_base('divers',$db)) query("DELETE FROM divers WHERE etab_id=$etab_id AND motcle='eleves'");
    $modele=$etab_modele_login_e;
    list($cr1_e,$cr2_e)=balayer_txt('eleve',$fichiereleves); 
    print '<br /><br />';
	}
if ($incorprofs) {
    query("DELETE FROM profs WHERE (tag>=1 OR compte_id IS NULL)
			AND etab_id=$etab_id"); //anciens incertains qui trainent
	if (table_dans_base('divers',$db)) query("DELETE FROM divers WHERE etab_id=$etab_id AND motcle='profs'");
    $modele=$etab_modele_login_p;
    list($cr1_p,$cr2_p)=balayer_txt('prof',$fichierprofs);
    print '<br /><br />';
	}


print "<p>";
if ($incoreleves) {
	//redonner des noms cohrents aux comptes rendus de balayer_txt()
	if ($cr1_e<0) {
		$erreurmap=$cr1_e;$entete=$cr2_e;
		errtxt($erreurmap,$fichiereleves,$entete);
		}
	else {
		$nbincertains_e=$cr1_e;$nbtraites_e=$cr2_e;
		print "Elves traits : $nbtraites_e. Incertains : $nbincertains_e.<br />";
		}
	}
if ($incorprofs) {
	if ($cr1_p<0) {
		$erreurmap=$cr1_p;$entete=$cr2_p;
		errtxt($erreurmap,$fichierprofs,$entete);
		}
	else {
		$nbincertains_p=$cr1_p;$nbtraites_p=$cr2_p;
		print "Profs traits : $nbtraites_p. Incertains : $nbincertains_p.";
		}
	}

print "</p>";

if ($nbincertains_e>0 || $nbincertains_p > 0)
    print "<h3><a href=\"incertains1.php\">Vrifier les lments incertains</a></h3>\n";
else
    print "<h3><a href=\"nettoyer.php\">Nettoyer les tables et terminer</a></h3>\n";
print "<p>&nbsp;</p>";
print "<p>&nbsp;</p>";
print "<p>&nbsp;</p>";
print "<p>&nbsp;</p>";
print "<a name=\"bas\"></a>";
voircetendroit();
enqueue();
?>