<?php
#G
#=
/****************************************************************************
Copyright 2002, Daniel Deycard, Jacques Messines, Stphanie Roussel, Jean-Marie Treins
(CATICE Acadmie de Bordeaux)

This file is part of Gibii/Melia

Gibii is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Gibii is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Gibii; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/

//Fonctions de suppression diverses (lves, profs, classes, tabs, resultats)

require_once("../include/utildb.inc.php");

function suppr_resultat_eid($eleve_id,$item_id,$disc_id) {
delcascade2("SELECT resultat_id FROM resultats WHERE eleve_id=$eleve_id AND item_id=$item_id AND disc_id=$disc_id",
			array("DELETE FROM lrp WHERE resultat_id",
					"DELETE FROM resultats WHERE resultat_id"));
}

function suppr_resultat($resultat_id) {
query("DELETE FROM resultats WHERE resultat_id=$resultat_id");
query("DELETE FROM lrp WHERE resultat_id=$resultat_id");
}

function suppr_resultats($eleve_id) {
delcascade2("SELECT resultat_id FROM resultats WHERE eleve_id=$eleve_id",
			 array("DELETE FROM resultats WHERE resultat_id",
			 	   "DELETE FROM lrp WHERE resultat_id"));
}

function suppr_eleve($elid,$mode=0) {   //mode!=0 mode bavard
//Effacement dans les tables annexes
query("DELETE FROM comptes WHERE eleve_id=$elid");
delcascade2("SELECT message_id FROM demandes WHERE eleve_id=$elid",
			array(	"DELETE FROM reponses WHERE message_id",
					"DELETE FROM demandes WHERE message_id"));
query("DELETE FROM brevets WHERE eleve_id=$elid");
suppr_resultats($elid);
query("DELETE FROM lien_eleves_disciplines WHERE eleve_id=$elid");
query("DELETE FROM lien_eleves_classes WHERE eleve_id=$elid");
if ($mode) $nom_elev=geteleve($elid);
$ok=query("DELETE FROM eleves WHERE eleve_id=$elid");
if ($mode) {
	if (!$ok) $bilan="<br />Erreur dans la suppression du compte lve  !";
	else $bilan="<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- Compte lve $nom_elev supprim.";
	}
else $bilan='';
return $bilan;
}

function suppr_classe($id,$mode) {   //Mode=0 Un retour par classe
                                     //Mode=1 Un retour par lve
global $etab_id;
$divcod=getclasse($id);
$ok=true;
if ($mode==1) $modelev=1; else $modelev=0;

//recherche des classes pour effacer chaque lve
//retourne un message + ou moins prcis suivant $mode
$sql_elev="SELECT eleves.*, comptes.login  FROM eleves, comptes, lien_eleves_classes ".
    " WHERE eleves.eleve_id=comptes.eleve_id ".
    " AND eleves.eleve_id=lien_eleves_classes.eleve_id ".
    " and eleves.etab_id=$etab_id and lien_eleves_classes.classe_id=$id";
$res_elev=query($sql_elev);
$mess="<br><b>Suppression des lves de $divcod...</b>";
while ($rowelev=@mysql_fetch_array($res_elev)) {
	$eleve_id=$rowelev["eleve_id"];
	$compte_id= $rowelev["compte_id"];
	$login=$rowelev["login"];
	//Suppression de l'lve eleve_id (sauf elve test)
	if (($login!="00000") && (isset($eleve_id)))
	$mess.=suppr_eleve($eleve_id,$modelev); //Suivant appel $mode
	}
//Suppression dans liens profs-classes  puis dans classes
query("DELETE FROM lien_profs_classes WHERE classe_id=$id");
if ($divcod!="Classe_Test") {
	$sqlclasse="DELETE FROM classes WHERE classe_id=$id";
	$ok=query($sqlclasse);
	//Au cas o, a a d partir avec les lves...
	query("DELETE FROM lien_eleves_classes WHERE classe_id=$id");
	if (!$ok) $mess.="<br>Erreur dans la suppression de la classe $divcod !";
		else $mess.="<br><b>* Classe $divcod supprime.</b>";
	} 
else $mess.="<br><b>* Classe $divcod conserve (avec 00000).</b>";
return $mess;
}


function suppr_profs_etab($mode) {  //mode 0 = muet 1= bavard 1 ligne par prof
   global $etab_id;
   $ok=true;
   //recherche des profs
   //pour traiter les tables de liens
   $sql_prof="SELECT profs.prof_id, login FROM profs, comptes ".
    " WHERE profs.prof_id=comptes.prof_id and profs.etab_id=$etab_id";
   $res_prof=query($sql_prof);
   $mess="<br><b>Suppression des comptes des professeurs...</b>";
   while (list($prof_id, $login)=@mysql_fetch_array($res_prof)) {
     $nom_prof=getprof($prof_id);
     if ($login!="proftest") {
      //effacement dans les tables annexes puis profs et comptes

      query("DELETE FROM lien_profs_classes WHERE prof_id=$prof_id;");
      query("DELETE FROM lpi WHERE prof_id=$prof_id;");
      query("DELETE FROM profs WHERE prof_id=$prof_id;");
      query("DELETE FROM comptes WHERE prof_id=$prof_id;");
      query("DELETE FROM lrp WHERE prof_id=$prof_id;");
      if ($mode!=0) $mess.="<br> - Compte professeur $nom_prof supprim.";
      }
   } //fin while
   $mess.="<br><b>Tous les comptes professeurs sont supprims (sauf proftest !)</b>";
    return $mess;
}


function suppr_profs($tliste) {
$t=array_chunk($tliste,100);
foreach($t as $tpart) {
	$lpart=implode(",",$tpart);
	query("DELETE FROM lien_profs_classes WHERE prof_id IN ($lpart)");
	query("DELETE FROM lpi WHERE prof_id IN ($lpart)");
	query("DELETE FROM profs WHERE prof_id IN ($lpart)");
	query("DELETE FROM comptes WHERE prof_id IN ($lpart)");
	query("DELETE FROM lrp WHERE prof_id IN ($lpart)");
	}
}

function suppr_eleves($tliste) {
$t=array_chunk($tliste,100);
foreach($t as $tpart) {
	$lpart=implode(",",$tpart);
	query("DELETE FROM lien_eleves_classes WHERE eleve_id IN ($lpart)");
	query("DELETE FROM eleves WHERE eleve_id IN ($lpart)");
	query("DELETE FROM comptes WHERE eleve_id IN ($lpart)");
	query("DELETE FROM brevets WHERE eleve_id IN ($lpart)");
	delcascade2("SELECT resultat_id FROM resultats WHERE eleve_id IN ($lpart)",
				array("DELETE FROM lrp WHERE resultat_id",
					  "DELETE FROM resultats WHERE resultat_id"));
	delcascade2("SELECT message_id FROM demandes WHERE eleve_id IN ($lpart)",
				array("DELETE FROM demandes WHERE message_id",
					  "DELETE FROM reponses WHERE message_id"));
	}
}
?>