<?php
#=
/****************************************************************************
Copyright 2002, Daniel Deycard, Jacques Messines, Stphanie Roussel, Jean-Marie Treins
(CATICE Acadmie de Bordeaux)
Copyright 2010, Fabien Nguyen

This file is part of Gibii/Melia.

Gibii/Melia is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Gibii/Melia is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Gibii/Melia; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/
include("../include/vars_adm.php");
include("../include/util.inc.php");
include("../include/get.inc.php");
include("../include/eleve.inc.php");
include("../include/utiljs.php");
include("../include/purges.inc.php");
require_once("../include/define.inc.php");

opensession("Eleve",false);

if (!isset($sess_mec_id)) die(PARAM_ABSENT);
$eleve_id=$sess_mec_id;

?><!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional //EN" >

<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
<title>Choix de l'lve</title>
<link rel="stylesheet" href="<?php echo '../themes/'.$etab_theme.'/b2i.css' ?>">
<!--[if lt IE 7]> <script  src="../include/fixed.js" type="text/javascript"></script> <![endif]-->
<!-- ncessaire pour les version 5   6 de IE pour muler l'attribut fixed.-->

<style type="text/css">
img#retour{
  position:fixed;
  right:10px;
  bottom:10px;
}
</style>
<!-- bien que ce style pour la flche de retour soit dans la CSS, IE7 ne l'interprte pas et il l'accepte s'il est l ????-->

<script language="javascript">
function wstatus(m) {
  //affichages dans la barre de statut
  var mess='';
  switch (m) {
      case 0 : mess='<?php echo JS_NO_REP_PROF; ?>';break;
      case 1 : mess='<?php echo JS_PAS_ASSEZ_REP; ?>';break;
      case 2 : mess='<?php echo JS_ITEM_OBTENU; ?>';break;
      case 3 : mess='<?php echo JS_VOIR_REPONSES; ?>';break;
      case 4 : mess='<?php echo JS_PAS_DEMANDE; ?>';break;
  }
  window.status=mess;
}

function soumettre() {
   window.document.formchoix.submit();
    return true;
}

function changeIMG(nameIMG,srcIMG) {
  if (document.images) {
      var monimg=document.images[nameIMG];
      monimg.src=srcIMG;
  }
}

function prechargeimg() {
  if (document.images) { //s'il y a des champs IMG dans le document
     var tabparams=prechargeimg.arguments;
     var tabimages=new Array();
     for (i=0; i<tabparams.length; i++) { //>
         tabimages[i]=new Image();
         tabimages[i].src="../themes/<?php echo $etab_theme; ?>/boutons/"+tabparams[i];
     }
  }
}

function compte_coches() {
    //compte le nombre d'items cochs et vrifie par rapport  ceux demands
    //alert('Dans compte_coches');
    var s=0;
    var nbcases=document.formchoix.elements.length;

    //limite est un "paramtre" pass par PHP mais qui se trouve tre
    //une constante lorsqu'on regarde le source de la page
    var limite=window.document.formchoix.lim.value;  //champ cach
    for(var i=0; i<nbcases ; i++)  //>
       if (document.formchoix.elements[i].checked) s++;
    if (s==0) {
        alert('<?php echo JS_AUCUN_COCHE; ?>');
        return false;
    }
    else {
        if (s>limite) {      //trop de coches
            if (limite<=0) { //n'a pas le droit de cocher
               alert('<?php echo tuvous(JS_TU_NE_PEUX,JS_VOUS_NE_POUVEZ).JS_PLUS_COCHER; ?>');
               document.formchoix.reset();

            }
            else {           //le nombre de coches dpasse le maximum
               alert('<?php echo tuvous(JS_TU_AS,JS_VOUS_AVEZ).JS_COCHE; ?>'+s+'<?php echo JS_ITEMS_LIMITE; ?>'+limite);
            }
            return false;
        }
        else return true;    //il a coch sans dpasser le max
    }
    }

function getpop(cible,w,h,l,t) {
   var param='width='+w+',height='+h+',left='+l+',top='+t+',status=0,directories=0,toolbar=0,menubar=0,location=0,scrollbars=1,resizable=1';
   fen=window.open(cible,'vasydefonce',param);
   fen_exist=true;
   window.fen.focus();
}

</script>
</head>
<body class="arialeleve" bgcolor="white" text="black" link="blue" vlink="purple" alink="red">

<?php include("../admin/competences.php"); ?>

<script language="javascript">
  prechargeimg(
    'edemande.gif','odemande.gif','ndemande.gif',
    'eacquis.gif','oacquis.gif','nacquis.gif',
              'e01.gif','e02.gif',
    'e10.gif','e11.gif','e12.gif',
    'e20.gif','e21.gif','e22.gif',
              'n01.gif','n02.gif',
    'n10.gif','n11.gif','n12.gif',
    'n20.gif','n21.gif','n22.gif',
              'o01.gif','o02.gif',
    'o10.gif','o11.gif','o12.gif',
    'o20.gif','o21.gif','o22.gif'
    );
</script>

<?php
 if ( $MODULE=='Melia'   and   (count($sess_lvchoix)==0)) {
    print PAS_LANGUE_DEFINIE;
    exit();
    }

print "<form name=\"formchoix\"
        method=\"post\"
        action=\"eleve_coche1.php?eleve_id=$eleve_id\">";

function italique($ch) {
    return "<i>".$ch."</i>";
    }

switch ($etab_niveau) {
    case "niv1": $condition=" brevet_no=1 ";break;
    case "niv2": $condition=" brevet_no=2 "; break;
    case "niv3": $condition=" brevet_no=3 "; break;
    case "niv12"  : $condition=" (brevet_no IN (1,2)) "; break;
    case "niv23"  : $condition=" (brevet_no IN (2,3)) "; break;
    default: $condition=" 1 ";
    }


//la flche de retour en haut de page
//-----------------------------------
print "<a href=\"#haut_de_page\"><img id=\"retour\" src='../themes/".$etab_theme."/retour.gif' border='0'></a>";
print "<a name=\"haut_de_page\"></a>";

//Lgende pour l'affichage d'une barre de boules reprsentant la progression de l'attestation
//-------------------------------------------------------------------------------------------
print "<div align='center'><table border='0' cellspacing='0'>\n
    <tr><td><span class='attention' >".ETAT_ACTUEL_ITEMS."</span>\n
        <td>&nbsp;</td>\n
        <td><table border='0' cellspacing='0' bordercolordark='white' bordercolorlight='gray'><tr><td><img src='../themes/".$etab_theme."/boule_verte.gif' ></td><td>".ACQUIS."</td></td></tr></table>\n
        <td>&nbsp;</td>\n
        <td><table border='0' cellspacing='0' bordercolordark='white' bordercolorlight='gray'><tr><td><img src='../themes/".$etab_theme."/boule_jaune.gif' ></td><td>".EN_COURS."</td></td></tr></table>\n
        <td>&nbsp;</td>\n
        <td><table border='0' cellspacing='0' bordercolordark='white' bordercolorlight='gray'><tr><td><img src='../themes/".$etab_theme."/boule_rouge.gif' ></td><td>".NON_ACQUIS."</td></td></tr></table>\n
        <td>&nbsp;</td>\n
     </tr>\n
    </table></div></br>\n";

//==============================================
//Rcupration hors boucle de toutes les donnes
//==============================================

print "<div align='center'><table border='1' cellspacing='0'cellpadding='0' bordercolordark='white' bordercolorlight='gray'>\n";
print "<tr class='impaire'>\n";

//les items et rubriques
//----------------------
$resit =query("SELECT items.item_id, items.obligatoire, libelles.base, rubriques.rub_no, rubriques.libelle
                FROM items, libelles, rubriques
                WHERE items.item_id = libelles.item_id
                AND rubriques.rub_no = items.rub_no
                AND $condition
                ORDER BY items.rub_no, items.s_rub_no");
$nb_items=mysql_num_rows($resit);  //ncessaire pour le dcalage de la bulle dans la boucle.

$firstit=0;
$totalit=0;
while (list($item_id,$item_oblig,$libbase,$rub_no,$librub)=mysql_fetch_array($resit))  {
    //stocker les rsultats de la requte pour rutilisation
    $totalit++;
    if (!$firstit) {
        $firstit=$item_id;
        $firstrub=$rub_no;
        }
    $lastit=$item_id;
    $lastrub=$rub_no;
    if ($item_oblig==0) $libbase=italique(stripslashes($libbase));
    $tlibit[$item_id]=$libbase;
    $trubno[$item_id]=$rub_no;     //pointeur vers la rubrique
    if (!isset($tlibrub[$rub_no])) {
        $tlibrub[$rub_no]=$librub; //nouvelle rubrique
        $tfirstitem[$rub_no]=$item_id;
        }
    $tlastitem[$rub_no]=$item_id;

    //on choisit le dcalage de la bulle
    if (($item_id-$firstit)<$nb_items/3) $decalbulle="decalbulleg";
    elseif (($item_id-$firstit)<2*$nb_items/3) $decalbulle="decalbullec";
    else $decalbulle="decalbulled";
    //on choisit la couleur de fond selon ecole ou collge ou lyce ; fonc si item optionnel
    if ($item_oblig==0) $coulfond="fondfonce";
    elseif ((substr($libbase,0,1)=="E")||(substr($libbase,0,1)=="L")) $coulfond="impaire";
    else $coulfond="paire";

	switch ($item_id) { //Fabien : cette condition permet de colorer les cases du bilan des comptences des lves d'une classe afin d'identifier plus rapidement les rubriques de chaque comptence.
			case 1 : //Comptence 1  La matrise de la langue franaise (rubriques 1  4)
			case 2 : 
			case 3 : 
			case 4 : 
			case 5 : 		
			case 6 : 
			case 7 : 
			case 8 : 
			case 9 : 
			case 10 : 
			case 11 : 
			case 12 : 
			case 13 : 
			case 14 : 		
			case 15 : 
			case 16 : 
			case 17 : 
			case 18 : 
			case 19 :
					print "<td width='16' align='center' class='tout_petit $coulfond' style='background-color:#3f62bc;'>
					<a class='bulle taillebullegde $decalbulle' href=\"#ancre-$item_id\">$item_id
					<span><b>Item $item_id</b><br/>$libbase</span></a></td>\n";
					break;
			case 20 : //Comptence 2  La pratique dune langue vivante (rubriques 5  9)
			case 21 : 
			case 22 : 
			case 23 : 
			case 24 : 
			case 25 : 
			case 26 : 
			case 27 : 
			case 28 : 		
			case 29 : 
			case 30 : 
			case 31 : 
			case 32 : 
			case 33 : 
					print "<td width='16' align='center' class='tout_petit $coulfond' style='background-color:#a0733a;'>
					<a class='bulle taillebullegde $decalbulle' href=\"#ancre-$item_id\">$item_id
					<span><b>Item $item_id</b><br/>$libbase</span></a></td>\n";
					break;
			case 34 : //Comptence 3  Les principaux lments de mathmatiques et la culture scientifique et technologique (rubriques 10  13)
			case 35 : 
			case 36 : 
			case 37 : 
			case 38 : 
			case 39 : 
			case 40 : 
			case 41 : 		
			case 42 : 
			case 43 : 
			case 44 : 
			case 45 : 
			case 46 : 
			case 47 : 
			case 48 : 
			case 49 : 
			case 50 : 		
			case 51 : 
			case 52 : 
			case 53 : 
			case 54 : 
			case 55 :
			case 56 : 
			case 57 : 
			case 58 : 
			case 59 : 		
			case 60 : 
			case 61 : 
			case 62 : 
			case 63 : 
			case 64 : 
			case 65 : 
			case 66 : 
			case 67 : 
			case 68 : 		
			case 69 : 
			case 70 : 
			case 71 : 
			case 72 : 
			case 73 :
			case 74 : 
					print "<td width='16' align='center' class='tout_petit $coulfond' style='background-color:red;'>
					<a class='bulle taillebullegde $decalbulle' href=\"#ancre-$item_id\">$item_id
					<span><b>Item $item_id</b><br/>$libbase</span></a></td>\n";
					break;
			case 75 : //Comptence 4  La matrise des techniques usuelles de linformation et de la communication (rubriques 14  18)
			case 76 : 
			case 77 : 
			case 78 : 
			case 79 : 
			case 80 : 
			case 81 : 
			case 82 : 
			case 83 : 
			case 84 : 
			case 85 : 
			case 86 : 		
			case 87 : 
			case 88 : 
			case 89 : 
			case 90 : 
			case 91 : 
			case 92 : 
			case 93 : 
			case 94 : 
			case 95 : 		
			case 96 : 
			case 97 : 
			case 98 : 
			case 99 : 
			case 100 :
			case 101 : 
			case 102 : 
			case 103 : 
					print "<td width='16' align='center' class='tout_petit $coulfond' style='background-color:black;'>
					<a class='bulle taillebullegde $decalbulle' href=\"#ancre-$item_id\">$item_id
					<span><b>Item $item_id</b><br/>$libbase</span></a></td>\n";
					break;
			case 104 : //Comptence 5  La culture humaniste (rubriques 19  24)
			case 105 : 
			case 106 : 
			case 107 : 
			case 108 : 
			case 109 : 
			case 110 : 
			case 111 : 		
			case 112 : 
			case 113 : 
			case 114 : 
			case 115 : 
			case 116 : 
			case 117 : 
			case 118 : 
					print "<td width='16' align='center' class='tout_petit $coulfond' style='background-color:#0ba228;'>
					<a class='bulle taillebullegde $decalbulle' href=\"#ancre-$item_id\">$item_id
					<span><b>Item $item_id</b><br/>$libbase</span></a></td>\n";
					break;
			case 119 : //Comptence 6  Les comptences sociales et civiques (rubriques 25  26)
			case 120 :
			case 121 : 
			case 122 : 
			case 123 : 
			case 124 : 		
			case 125 : 
			case 126 : 
			case 127 : 
			case 128 : 
			case 129 : 
					print "<td width='16' align='center' class='tout_petit $coulfond' style='background-color:#a947e8;'>
					<a class='bulle taillebullegde $decalbulle' href=\"#ancre-$item_id\">$item_id
					<span><b>Item $item_id</b><br/>$libbase</span></a></td>\n";
					break;
			case 130 : //Comptence 7  Lautonomie et linitiative (rubriques 27  28)
			case 131 : 
			case 132 : 
			case 133 :
			case 134 : 
			case 135 : 
			case 136 : 
			case 137 : 		
			case 138 : 
			case 139 : 
			case 140 : 
					print "<td width='16' align='center' class='tout_petit $coulfond' style='background-color:#d753b0'>
					<a class='bulle taillebullegde $decalbulle' href=\"#ancre-$item_id\">$item_id
					<span><b>Item $item_id</b><br/>$libbase</span></a></td>\n";
					break;
		}
    //print "<td width='16' align='center'class='tout_petit $coulfond'>
    //        <a class='bulle taillebullegde $decalbulle' href=\"#ancre-$item_id\">$item_id
    //        <span><b>Item $item_id</b><br/>$libbase</span></a></td>\n";
    } //Fin titres
print  "</tr>\n";
mysql_free_result($resit);

//---------------------------------------
//Rectifier les libells par les libperso
//---------------------------------------
$resperso=query("SELECT item_id,libelle FROM libelles_perso WHERE etab_id=$etab_id");
while (list($item_id,$lib)=mysql_fetch_array($resperso)) {
    if (isset($tlibit[$item_id])) {
    	//l'item fait partie du niveau choisi par l'tab
		if (substr($tlibit[$item_id],0,3)=="<i>") $lib=italique($lib);
    	$tlibit[$item_id]=$lib;
    	}
    }
mysql_free_result($resperso);


//---------------------------------------------------------------
//Les rsultats : les couples (item_id,message_id sont conservs)
//(obligatoire car le rsultat peut tre l alors que la demande a disparu)
//---------------------------------------------------------------
//ATTENTION  la discipline !
if ($MODULE=='Melia') $wher=" AND r.disc_id=$disc_id ";
else $wher="";

$titobt=array_fill($firstit,$totalit,0);
$resres=query("SELECT r.item_id,d.message_id
                FROM resultats AS r
                LEFT JOIN demandes AS d
                ON d.item_id=r.item_id  AND d.eleve_id=r.eleve_id  AND d.disc_id=r.disc_id
                WHERE r.eleve_id=$eleve_id".$wher);
while (list($item_id,$message_id)=mysql_fetch_array($resres)) {
    if (!isset($message_id)) $message_id=-1; //demande perdue
    $titobt[$item_id]=$message_id;
    }
mysql_free_result($resres);
//print_r($titobt);print "<br>";


//------------------------------------------------------------------
//Enregistrer en tableau toutes les demandes et rponses associes :
//------------------------------------------------------------------
$titdem=array();
//on cherche les demandes de l'lve en regroupant en regard les rponses associes
$resdem=query(" SELECT message_id,
                    item_id,
                    TO_DAYS( NOW( ) ) - TO_DAYS( demandes.quand ),
                    active,obtenue,
                    nboui,nbnon,longue                    
                FROM demandes
                WHERE eleve_id =$eleve_id
                AND disc_id=$disc_id
                AND (active=1 OR obtenue=1)
                ");
while (list($message_id,$item_id,$nj,$actif,$obtenu,$nacc1,$nacc0,$longue)=mysql_fetch_array($resdem)) {
    //ne pas comptabiliser les items dj obtenus
    if (@$titobt[$item_id]) continue;    //dtail des demandes sans intrt dans ce cas
    if (!onVientDeLaMemePage() 
        && 
        est_inactivee($message_id,$eleve_id,$item_id,$disc_id,$nj,$nacc0,$nacc1,$longue)) 
        {
        //la demande a t dsactive ou supprime
        //print"oncontinue !!!";
        continue;
        }
    $titdem[$item_id]=array();
    $demrep=&$titdem[$item_id];         //pour simplifier...
    $demrep['oui']=$nacc1;
    $demrep['non']=$nacc0;
    $demrep['nj']=$nj;
    $demrep['dem']=$message_id;
    }
mysql_free_result($resdem);

$nbattente=count($titdem);

//Conserver en session les tableaux laborieusement calculs
//---------------------------------------------------------
$_SESSION['sess_titobt']=&$titobt;
$_SESSION['sess_titdem']=&$titdem;

//Affichage des comptences (n et boules colores)
//-------------------------------------------------
$title=' title="'.CLIQUER_NO.'" ';
print "<tr class='paire'>\n";
for ($item_id=$firstit ; $item_id<=$lastit ; $item_id++)  {
    if ($titobt[$item_id])  {
        $cellule="\t<td align=\"center\"><img src=\"../themes/".$etab_theme."/boule_verte.gif\"  $title></td>";}
    elseif (isset($titdem[$item_id]))
            $cellule="\t<td align=\"center\"><img src=\"../themes/".$etab_theme."/boule_jaune.gif\"  $title></td>";
    else    $cellule="\t<td align=\"center\"><img src=\"../themes/".$etab_theme."/boule_rouge.gif\"  $title></td>";
    print $cellule;
}

print "</tr>";
print "</table></div>";
print "<br />";

if ($MODULE=='GiBii' && strpos($etab_niveau,'3')) 
    print "<p class='warning avis' align='center'><i>Les items sur fond plus sombre et en italique sont optionnels (niveau Lyce-CFA)</i><p>\n";
else print "<br />";

//==========================================================
//afficher la situation de l'lve par rapport  chaque item
//==========================================================
//en mme temps, comptabiliser le nombre d'items en attente
//l'lve ne pourra pas dpasser le nombre de demandes max en comptant
//les coches ET les demandes en cours

$limite=$etab_nb_max_demandes;
$idximg=0;  //numros des champs IMG
$chemin="../themes/$etab_theme/boutons";
//$nbitemsnew=count($item_new);

for ($num_rub=$firstrub ; $num_rub<=$lastrub ; $num_rub++) {
    $nbitems=$tlastitem[$num_rub]-$tfirstitem[$num_rub]+1;
    //Afficher rubrique et niveau correspondant

    print "<p class='rubrique'>".$tlibrub[$num_rub];
    if ($MODULE!="Melia") print " (".getlibellenivo(getnivo($num_rub)).")";
    //if ($MODULE=="GiCii") print " (niveau : ".getnivo($num_rub).")";
    print "</p>";
    print "<table  border=0 width='100%'>\n";
    for ($item_id=$tfirstitem[$num_rub] ; $item_id<=$tlastitem[$num_rub] ; $item_id++) {
         $ancre="ancre-".$item_id;
         //couleur de la ligne suivant sa parit
         $cl=($item_id%2==0) ? "paire" : "impaire";
         print "<tr class='$cl'>\n";
         print "<a name=\"$ancre\"></a>\n";

         //colonne 1 : l'tat ou l'action possible sur l'item
         print "<td align='center' width='100' >\n";
         $nomtagimg="img".$idximg;

         if ($titobt[$item_id])  {
             $message_id=$titobt[$item_id];  //peut tre -1 ou 1,2,3,...
             $nombasefic="acquis.gif";
             $typeres="a";
             $ancre="<img name='$nomtagimg' src='$chemin/n$nombasefic' width='91' height='26' border='0' alt='".ITEM_OBTENU."' title='".ITEM_OBTENU."'>";
             $mouseover=" onmouseover=\"changeIMG('$nomtagimg','$chemin/o$nombasefic');wstatus(2);\" \n";
             $mousedown=" onmousedown=\"changeIMG('$nomtagimg','$chemin/e$nombasefic');wstatus(3);\" \n";
             $mouseout =" onmouseout =\"changeIMG('$nomtagimg','$chemin/n$nombasefic');wstatus(-1);\" \n";
             $typebouton=true;
             }
         elseif (isset($titdem[$item_id])) {
             $demrep=&$titdem[$item_id];
             $message_id=$demrep['dem'];
             $mouseover=$mousedown=$mouseout="";
             $nboui=$demrep['oui'];$nbnon=$demrep['non'];
             $typebouton=true;
             if (($nboui==0) && ($nbnon==0)) {
                 $typeres="ec";
                 $limite--;
                 $nombasefic="demande.gif";
                 $ancre="<img name='$nomtagimg' src='$chemin/n$nombasefic' width='91' height='26' border='0' alt='".DEMANDE_COURS."' title='".DEMANDE_COURS."'>";
                 $mouseover=" onmouseover=\"changeIMG('$nomtagimg','$chemin/o$nombasefic');wstatus(0);\" \n";
                 $mousedown=" onmousedown=\"changeIMG('$nomtagimg','$chemin/e$nombasefic');wstatus(3);\" \n";
                 $mouseout =" onmouseout =\"changeIMG('$nomtagimg','$chemin/n$nombasefic');wstatus(-1);\" \n";
                 }
             elseif ($nboui<4 && $nbnon<4) {
                 $typeres="on";
                 if ($demrep['nj']>$etab_nbj_vie_demande) {
                    //demande longue
                    $nombasefic="demandelongue.gif";
                    }
                 else {
                    $limite--;
                    $nombasefic=$nboui.$nbnon.".gif";
                    $mouseover=" onmouseover=\"changeIMG('$nomtagimg','$chemin/o$nombasefic');wstatus(1);\" \n";
                    $mousedown=" onmousedown=\"changeIMG('$nomtagimg','$chemin/e$nombasefic');wstatus(3);\" \n";
                    $mouseout =" onmouseout =\"changeIMG('$nomtagimg','$chemin/n$nombasefic');wstatus(-1);\" \n";
                    }
                 $ancre="<img name='$nomtagimg' src='$chemin/n$nombasefic' width='91' height='26' border='0' alt='".OUI." : $nboui  ".NON." : $nbnon'  title='".OUI." : $nboui  ".NON." : $nbnon'>";
                 }
             else {                //pas d'image disponible...
                 $typeres="on";
                 $ancre=OUI.":".$nboui."<br />".NON.":".$nbnon;
                 if ($demrep['nj']>$etab_nbj_vie_demande) {
                     $ancre.="<br />demande longue";
                     }
                 else $limite--;        //sauf si vieille demande et autorisation ???
                 $mouseover="";
                 $mousedown="";
                 $mouseout="";
                 }
             }
         else  {
             //pas de demande ou date de la demande >30
             $typebouton=false;
             }
         if ($typebouton) {
             print "<a href=\"eleve_traiter.php?message_id=$message_id&eleve_id=$eleve_id&item_id=$item_id&typeres=$typeres\"";
             print $mouseover;
             print $mousedown;
             print $mouseout;
             print " >\n";
             print "$ancre</a>\n";

             //colonne 1,5 : affichage pop-up info profs UNIQUEMENT sur demande faite
             //----------------------------------------------------------------------
 /*            if (($MODULE!='Melia') || ($etab_nb_validations>1) ) {
                  $target="pop_profs_possibles.php?eleve_id=$eleve_id&item_id=$item_id".
                           "&message_id=$message_id";
                  print "<a href=\"javascript:void(0)\"
                          onClick=\"getpop('$target',600,300,150,50)\">
                          <img width='24' height='24' border='0'
                          src=\"../themes/".$etab_theme."/ie.gif\"
                          title=\"Qui peut valider ma demande ?\"></a>";
                  }  */
             }
         else {
             print "<input type='checkbox' name='CBItem[]' value=$item_id>\n";
             $message_id=0; //pour signaler dans la pop qu'il n'y a pas de demande
             }

             print "\n\t</td>\n";
             print "\n\t<td width='25'>\n";
             // colonne 2 ; affichage de la popup info qui valide pour tous les items
             // en test en remplacement  du test prcdent.
             if ($MODULE!='Melia')  {
             $target="pop_profs_possibles.php?eleve_id=$eleve_id&item_id=$item_id".
                           "&message_id=$message_id";
                  print "<a href=\"javascript:void(0)\"
                          onClick=\"getpop('$target',600,300,150,50)\">
                          <img width='24' height='24' border='0'
                          src=\"../themes/".$etab_theme."/ie.gif\"
                          title=\"Qui peut valider ma demande ?\"></a>";
              }
         print "\n\t</td>\n";
         $idximg++;

         //colonne 2 : le texte de l'item
         //------------------------------
         print "\n\t<td><p class='item'>\n";
         print  "[".$item_id."]";
         print "&nbsp;";
         print $tlibit[$item_id];
         print "\n\t</p></td></tr>\n";
         } //for $item_id=$tfirstitem[$num_rub]
    print "</table>\n";
    } //while rowrub
print "<input type=\"hidden\" name=\"lim\" value=\"$limite\">";
print "<input type=\"hidden\" name=\"nbattente\" value=\"$nbattente\">";
print "</form>";
?>
</body>
</html>