<?php
#=
/*
Copyright 2002-2004, Daniel Deycard, Jacques Messines, Alain Pomirol
(CATICE Acadmie de Bordeaux)

This file is part of GiBii/Melia.
GiBii/Melia is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

GiBii/Melia is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GiBii/Melia; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

include("../include/vars_adm.php");
include("../include/util.inc.php");
include("../include/utildb.inc.php");
include("../include/utiljs.php");
include("../backup/guide.inc.php");

@session_start();
recupvars(); //globalise les variables de session mais elles sont inacessibles


function choisir() {
global $etab_rne, $HIDEDATA;
$PHP_SELF=basename($_SERVER['PHP_SELF']);
print "<hr><p class=\"sous_sous_titre\">Indiquez un fichier de backup (extensions sql, gz et bz2 acceptes)</p>";
//print "<br />";
print "<center><FORM method=\"post\" action=\"$PHP_SELF\" enctype=\"multipart/form-data\">\n";
print "<p >\n";
print "Slectionnez le fichier qu'un prcdent backup vous a fourni : ";
print "<input type=\"file\" name=\"fichier\" onchange=\"filechange(this.form.ficintra);\">";
print "<input type=\"hidden\" name=\"MAX_FILE_SIZE\" VALUE=\"8000000\">";
print "</p></center>\n";
$rep="$HIDEDATA/$etab_rne/backup/";
$handle=opendir(creertousrep($rep));
$nb=0;
//on ne fait afficher le tableau et son en-tte que s'il n'est pas vide
//do le passage sans affichage
$aff='';
@setlocale(LC_TIME, "fr_FR", "FRA", 'france', 'french');
while ($file=readdir($handle)) {
    $nomcomplet=$rep.$file;
    if ($file!='.' && $file!='..' && is_file($nomcomplet)) {
        $p=strrpos($file,'.');
        if ($p!==false) $ext=strtolower(substr($file,$p+1));
        else $ext='';
        if ($ext=='sql' || $ext=='gz' || $ext=='bz2') {
            $aff.="<tr><td>";
			//<a href=\"$PHP_SELF?bouton=1&srvfic=".urlencode($nomcomplet)."\">&nbsp;$file</a>
			$aff.="<input type=\"radio\" name=\"ficintra\" value=\"$nomcomplet\" onclick=\"this.form.fichier.value='';\" />&nbsp;$file</td>\n";
            $stats=stat($nomcomplet);
            $taille=round($stats[7]/1024);
            $date=strftime('%A %d %B %Y  %H:%M:%S',$stats[9]);
            $aff.="<td style=\"text-align=center\"> $taille </td>\n"; //taille en Koctets

            $aff.="<td>&nbsp; $date </td>\n"; //date dernire modif
            $aff.="</tr>\n";
            $nb++;
        	}
    	}
	}

if ($nb>0) {
	?>
	<br />";
	<p class="sous_sous_titre">Vous pouvez aussi slectionner un fichier dans la liste ci-dessous (fichiers stocks sur le serveur) :</p>
	<div align='center'>
	<table width="90%" border='1'>
	<tr class='rubrique'>
		<td width="40%"> Fichier </td>
	    <td width="20%"> Taille (Ko)</td>
	    <td > Date </td>
	</tr>
	<?php 
	print $aff;
	print "</table></div>";
	}
	?>	
<br /><br />

<div align="center">
<table width="50%" border="1">
	<tr><td>
		<input type="checkbox" name="vider" title="Vider l'tablissement avant de le restaurer">
		</td>
		<td>
		<b>Si la restauration a lieu dans le <u>m&ecirc;me site</u>, <u>m&ecirc;me &eacute;tablissement</u>,
		cocher cette case pour <i>supprimer</i> toutes les donn&eacute;es cr&eacute;&eacute;es depuis le backup</b>
		<font face="MS Sans Serif" size="-2">(pour une restauration dans un autre site, cette case &agrave; cocher 
			est ignor&eacute;e et l'&eacute;tablissement est systmatiquement vid&eacute;)</font>
		</td>
	</tr>
</table>
<br /><br />
<input type='submit' class='coul' name='bouton' value='Restaurer'>
</form></div>
<?php
}

function erreur($mess) {   //pour le 2e passage
alert($mess);
gohistory(-1);
print "</body></html>";
exit();
}

function chksum_verif($nom) {
global $crlf;
$modele_cs='# checksum=';
$fp=fopen($nom,"r");
if (!$fp) return "impossible d'ouvrir le fichier en lecture (s'il existe !)";
$csfic=0;
$contenu='';
while (!feof($fp) && !$csfic) {
    $ligne=fgets($fp,1024);
    $m=strpos($ligne,$modele_cs);
    if ($m!==0) $contenu.=$ligne;
    else
        $csfic=substr($ligne,$m+strlen($modele_cs));
}
if ($csfic!=crc32($contenu)) return "somme de contrle incorrecte";
return "";
}

function enregistrer() {
global $etab_rne, $HIDEDATA;
$erreur="";
$copies="";
$infosfichier=$_FILES['fichier'];
//print_r($infosfichier);print "<br>";
$nom=strtolower($infosfichier['name']);
if (empty($nom)) erreur('Pas de fichier indiqu !');
$type=$infosfichier['type'];
$tmp_name=$infosfichier['tmp_name'];

$size=$infosfichier['size'];
$error=$infosfichier['error'];
if ($tmp_name=='none' || $size==0) erreur("Le fichier n'existe pas ou a une taille nulle ou trop importante.");
if ($error) erreur("Erreur $error pour $nom (tmp_name=$tmp_name)");
$dest="$HIDEDATA/$etab_rne/backup/$nom";
if (!move_uploaded_file($tmp_name,creertousrep($dest))) erreur("Erreur de copie vers $dest.");
return $dest;
}

function decompresser($nomfichier) {
global $etab_id, $etab_rne, $HIDEDATA;
if (ereg("\.(bz2|gz|sql)$" , $nomfichier, $cr)) {
	  $represtore="$HIDEDATA/$etab_rne";
	  creertousrep($represtore);
    $restore=$represtore.'/'.$etab_id.'_'.date('Ymd').'.sql';
    switch ($cr[1]) {
        case 'bz2':
             $fbz2=bzopen($nomfichier,'r');
             $fsql=fopen($restore,'w');
             while ($s=bzread($fbz2,10000)) fwrite($fsql,$s);
             fclose($fsql);
             bzclose($fbz2);
             break;
        case 'gz':
             $fgz=gzopen($nomfichier,'r');
             $fsql=fopen($restore,'w');
             while ($s=gzread($fgz,10000)) fwrite($fsql,$s);
             fclose($fsql);
             gzclose($fgz);
             break;
        case 'sql':
             $restore=$nomfichier;
             break;
    }

    $cstheorique=substr(basename($nomfichier),0,6);
    $csreel=substr(md5_file($restore),0,6);
    print "Check-sum thorique : $cstheorique<br>";
    print "Check-sum relle    : $csreel<br>";
    //if ($cstheorique!=$csreel) erreur("Contenu du fichier incorrect : la somme de contrle ne convient pas.");

}
else $restore="";
return $restore;
}



function foire($par,$vbackupx='') {
//vcorrectx est la version correcte pour restaurer, sans les centimes (par exemple 4.6.x)
global $MODULE,$VERSION_GIBII;
print "<h3>Ce fichier ne peut pas tre utilis.</h3>";
print "<h4>";
print $par;
print "</h4>";
if ($vbackupx) {
    print "<p><em>";
    print "Pour utiliser ce backup avec cette version de GiSCCo, il faut quelques tapes intermdiaires...
    		<br /><br /><ul><b>Sur une machine locale :</b>

    		<li> installez une version de $MODULE $vbackupx,
    		<li> restaurez votre tablissement en mode admin,</li>
    		<li> mettez les scripts de $MODULE  jour pour obtenir une version $VERSION_GIBII,</li>
    		<li> mettez la base  jour en copiant les fichiers de sadmin/maj_faite vers sadmin/maj puis en
    		  lanant la page sadmin,</li>
    		<li> effectuez un backup,</li>
    		<li> revenez ici et injectez ce backup.</li>
    		</ul>";
    print "</em></p>";
	}
exit();
}

function verifiebackup() {
global $tini,$MODULE,$VERSION_GIBII,
		$sitebkp,$etab_idbkp;

;
//rcuprer les directives
//print_r($tini);
if (!isset($tini['#'])) foire("Il est antrieur  la version 4.6.1","correspondant  votre backup");

$programme=$tini['#']['module'];
if ($programme!='GiBii') foire("Ce backup n'est pas relatif  $MODULE mais  $programme");
$versionbkp=$tini['#']['version'];

$v=explode('.',$versionbkp);
$vbackupx=$v[0].'.'.$v[1].'.x';
$v=explode('.',$VERSION_GIBII);
$vgibiix=$v[0].'.'.$v[1].'x';

$vact=(int) (vbase100($VERSION_GIBII)/100);
$vbackup=(int) (vbase100($versionbkp)/100);

if ($vact-$vbackup>=1)
	foire("Ce backup est trop ancien ($versionbkp)
			alors que la version actuelle de GiSCCo est la $VERSION_GIBII.
			Il faut une version $vbackupx.",$vbackupx);
if ($vbackup-$vact>=1)
	foire("Ce backup a t cr par la version $versionbkp.
			Il est plus rcent que la version de GiSCCo actuelle ($VERSION_GIBII).");

$sitebkp=$tini['#']['site'];
$etab_idbkp=$tini['#']['etab_id'];
}

//-------------  ppal  -------------------
/*Rcupration max 
	par POST : 
	[MAX_FILE_SIZE] => 8000000 
	[ficintra] => ../prive/0400042D/backup/af9c63_0400042d_nov515_20071117.sql 
	[vider] => on 
	[bouton] => Restaurer 
	
	par FILES
	[fichier] => Array ([name] => af9c63_0400042D_nov515_20071117.sql 
						[type] => application/octet-stream 
						[tmp_name] => c:\TEMP\php7F03.tmp 
						[error] => 0 
						[size] => 1332384 )
*/
opensession('Admin',false);
connecte($host,$user,$mdp,$db);

?><HTML><HEAD>
		<link rel="stylesheet" href="../themes/<?php print $etab_theme; ?>/b2i.css">
        <style>
			.gros    {
				font-family: Verdana, Geneva, Arial, Helvetica, "sans-serif";
				font-size:14px;
				font-weight:bold;
				padding-left:5px;
				color: Navy;
				}
		</style>
		<script type="text/javascript">
		function filechange(objradio) {
			//alert(typeof(objradio[0]));
			objradio.checked=false; //pour firefox qui ne sait pas grer les radios solitaires
			for (var i=0; i<objradio.length; i++) {
				objradio[i].checked=false;
     			}
			}
		</script>
		<meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
		<title>Backup de la base <?php  print $db; ?></title></head>
		<BODY class="arialadmin">
		<p class="sous_titre">Restauration de votre tablissement</p>
		
<?php
ini_set('file_uploads','On');         //autorise l'upload
ini_set('upload_max_filesize','20M');
if (!isset($bouton)) {
    //ini_set('upload_max_filesize','4M');
    choisir();
	}
else {
	set_time_limit(0);
    if (empty($_FILES['fichier']['name'])) {
		$nomrecu=$ficintra;
		if (isset($ficintra)) $nomrecu=$ficintra;
		else erreur('Pas de fichier choisi !');
		}
    else $nomrecu=enregistrer();

    print "<p style=\"text-align:center\">";
    if ($nomrestore=decompresser($nomrecu)) {
        $tini=parse_ini_file($nomrestore,true);   //global dans les fonctions
        verifiebackup(); 			//on peut ne pas en revenir...

		//inclure le fichier correspondant au cas trouv
		if ($sitebkp==$SITE_GIBII && $etab_idbkp==$etab_id) {
			if (isset($vider)) $vider=true; else $vider=false;
			include("./restore_identique.inc.php");
			}
		else {
			include("./restore_different.inc.php");
			}	
		
		//le traitement est ensuite le mme dans les 2 cas (mme fonctions)
		foreach($tini as $table => $contenu) {  //par ex. $table='eleves'  (une section de l'ini)
			if ($table=='#') continue;
			print "<h3 class=\"gros\">Table $table</h3>";
			$libfonction=getguide($table,'fonct');
			$libfonction($table);
		    }
		print "<hr>\n";
        print "<p><b><big>Restauration effectue </big></b>";
        print "</p><br />";
    }
    else alert("Le fichier fourni ($nomrecu)\nn'a pas l'extension voulue (sql, bz2 ou gz).");
    retour("../admin/admin_bas.php");
}
print "</body></html>";
?>