<?
#=
/****************************************************************************
Copyright 2002, Daniel Deycard, Jacques Messines, Stphanie Roussel, Jean-Marie Treins
(CATICE Acadmie de Bordeaux)

This file is part of GiBii/Melia.

GiBii/Melia is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

GiBii/Melia is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GiBii/Melia; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/
setlocale (LC_TIME, 'fr_FR.ISO_8859-1', 'fr_FR','fr_fr','fr','fra','fr_FR@euro');
include("../lib/fpdf.php");

//Prparation de la page des etiquettes
creertousrep("$DATA/$etab_rne/diplomes/");
$filename = $DATA."/".$etab_rne."/diplomes/etiquettes.pdf";

$date_pdf = date("d/m/Y");
$mois_pdf = strftime("%B %Y", mktime(0, 0, 0, date('m'), date('d'), date('Y')));
$title = "Etiquettes des rsultats du B2i - $etab_nom ($date_pdf)";

$fp=fopen($filename,"w");

fputs ($fp,"<?php\n");
fputs($fp,"Header('Pragma:Public');\n");
fputs ($fp,"include('../../../include/util.inc.php');\n");
fputs ($fp,"include('../../../lib/fpdf.php');\n");
fputs ($fp,"require_once('../../../include/define.inc.php');\n");
fputs ($fp,"include('../../../include/vars_adm.php');\n");
fputs ($fp,"include('../../../include/attestations.inc.php');\n");
fputs ($fp,"$pdf=new FPDF('P','mm','A4');\n");
fputs ($fp,"$pdf->SetMargins(10,10,10);\n");
fputs ($fp,"$pdf->SetAuthor('CATICE Acadmie de Bordeaux');\n");
fputs ($fp,"$pdf->SetCreator('GiBii/Mlia');\n");
fputs ($fp,"$pdf->SetTitle($title);\n");
fputs ($fp,"$pdf->SetDrawColor(200);\n");
fputs ($fp,"$pdf->SetLineWidth(0.1);\n");

	
$div = "";
$cpt = 1;

//  planche de  de 8 tiquettes par page -> CHOIX RETENU
for ($i=1; $i<$line_pdf; $i++) {
	$data = $res_pdf[$i];	
	if ($div != $data[1] && $cpt%8 != 0) {
		// Nouvelle page sauf si l'tiquette prcdente tait la 8eme
		fputs ($fp,"$pdf->AddPage();\n");
		$div = $data[1];
		$cpt = 0;
		}
	$cpt++;
	// En-tete d'tiquette
	fputs ($fp,"$pdf->SetFont('Arial','',7);\n");
	fputs ($fp,"$pdf->Cell(160,3,$etab_nom.\" - Anne scolaire \".$sess_ascol.\"-\".($sess_ascol+1),'B',0);\n");
	fputs ($fp,"$pdf->SetFont('Arial','B',7);\n");
	fputs ($fp,"$pdf->Cell(30,4,\"Classe : \".$data[1],1,1,'C');\n");
	fputs ($fp,"$pdf->SetFont('Arial','B',10);\n");
	fputs ($fp,"$pdf->Cell(150,4,\"Validation des Comptences informatiques\",0,0,'L');\n");
	fputs ($fp,"$pdf->SetFont('Arial','',7);\n");
	fputs ($fp,"$pdf->Cell(40,4,$mois_pdf,0,1,'R');\n");
	fputs ($fp,"$pdf->SetFont('Arial','B',12);\n");
	fputs ($fp,"$pdf->Cell(190,7,$data[2].\" \".$data[3],0,2,'C');\n");
	
	// Test du type de B2i choisi par l'tablissement
	fputs ($fp,"$pdf->SetFont('Arial','',10);\n");
	if (!strpos($etab_niveau, "1") || !strpos($etab_niveau, "2" || !strpos($etab_niveau, "3")))
		fputs ($fp,"$pdf->Cell(190,4,\"\",0,2);\n");
	if (strpos($etab_niveau, "1"))
		fputs ($fp,"$pdf->Cell(190,4,\"B2i cole \".($data[6]==0? \"non \":\"\").\"acquis (\".$data[5].\"% des items valids)\",0,2,'C');\n");
	if (strpos($etab_niveau, "2"))
		fputs ($fp,"$pdf->Cell(190,4,\"B2i Collge \".($data[8]==0? \"non \":\"\").\"acquis (\".$data[7].\"% des items valids)\",0,2,'C');\n");
	if (strpos($etab_niveau, "3"))
		fputs ($fp,"$pdf->Cell(190,4,\"B2i Lyce-CFA \".($data[10]==0? \"non \":\"\").\"acquis (\".$data[9].\"% des items valids)\",0,2,'C');\n");
	else fputs ($fp,"$pdf->Cell(190,4,\"\",0,2);\n");
	if (!strpos($etab_niveau, "1") && !strpos($etab_niveau, "2"))
		fputs ($fp,"$pdf->Cell(190,4,\"\",0,2);\n");
	
	if ($cpt%8 == 0) {
		// Nouvelle page aprs la 8eme tiquette
		fputs ($fp,"$pdf->AddPage();\n");
		}
	else {
		// Ligne pointille horizontale aprs l' tiquette
		fputs ($fp,"$pdf->Ln(6);\n");
		fputs ($fp,"\$y = (\$pdf->GetY()-3);\n");
		fputs ($fp,"pdf_ligne_h($fp,$y);\n");
		}
	}	

fputs ($fp,"$pdf->Output();\n");
//$pdf->Output($filename,'D');
?>