<?php
#=
/****************************************************************************
Copyright 2002, Daniel Deycard, Jacques Messines, Alain Pomirol
(CATICE Acadmie de Bordeaux)

This file is part of Gibii.

Gibii is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Gibii is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Gibii; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/
?><!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
<title>Vrification des demandes et rponses</title>
<link rel="stylesheet" href="../include/general.css" />
<base target="_self" />
<style type="text/css" media="screen">
	.beau {
		font-family: Verdana, Tahoma, Roman;
		font-weight: bold;
		}
</style>
</head>
<body class="arial_sadmin" bgcolor="white" text="black" link="blue" vlink="purple" alink="red">
<?php
define("debug",false);
define("TAB","&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
	
include("../include/vars_adm.php");
include("../include/util.inc.php");
include("../include/utiljs.php");

function printbleu($id) {
//affiche un n de demande ne posant pas de pb... mais obtenu par la requte
print "<span style=\"color:blue\"><b><i>$id - </i></b></span>\n";
}

function printdemrep($id,$code) {
//affiche et supprime les anomalies
static $titre=array('a' => "Ajout d'un rsultat",
					's' => "Suppression d'une demande et de ses rponses",
					'r' => "Rponses supprimes car redondantes"
					);
global 	$eid,$iid,$did,
		$nomelv,$prenomelv,$classeid,
		$etid,$bilan,$nbaccetab,$nbrefusetab,$datedem,$tnomprof,$tprenomprof,
		$trid, $tpid, $tacc, $tdaterep, $trepdel,
		$nometab,$codepostal;

print "<br /><br />\n";
print "<fieldset><legend>";
//le mme champ dem sert pour les 3 actions possibles
print "<input type=\"checkbox\" name=\"tfdem[$id][$code]\" value=\"1\" checked=\"checked\" />\n";
//pour l'ajout de rsultat, il faut 3 renseignements supplmentaires,  moins de faire un INSERT sur SELECT
if ($code=='a') {
	print "<input type=\"hidden\" name=\"tfdem[$id][i]\" value=\"$iid\"  />\n";
	print "<input type=\"hidden\" name=\"tfdem[$id][e]\" value=\"$eid\"  />\n";
	print "<input type=\"hidden\" name=\"tfdem[$id][d]\" value=\"$did\"  />\n";
	}
//pour la suppression, l'item_id suffit. 
print "<span style=\"font-size: 12pt;font-style: italic;font-weight: bold;color: Navy;\">\n";
print $titre[$code];
print "\n</span></legend>";
print "<p>";
//affichage des renseignements 
print "<span class=\"beau\">Etablissement</span> : id=$etid, nom=$nometab <b>($codepostal)</b>, tab_oui=$nbaccetab, tab_non=$nbrefusetab<br />\n";
print "<span class=\"beau\">Elve</span> : id=$eid - $nomelv $prenomelv, idclasse=$classeid<br />\n";
print "<span class=\"beau\">Demande</span> : id=$id, bilan=$bilan, item=$iid, disc=$did, date=$datedem<br />\n";
print "<span class=\"beau\">Rponses</span> : <br />\n";
$nbrep=count($trid);
for ($r=0;$r<$nbrep;$r++) {
	if ($code!='s' && in_array($trid[$r],$trepdel)) {
		$msupp=TAB.'<i><b> ~~>  effacer ! </b></i>';
		print "<input type=\"hidden\" name=\"tfdem[$id][$r]\" value=\"".$trid[$r]."\"  />\n";
		}
	else $msupp='';
	print TAB."- rponse n ".($r+1)." : id=".$trid[$r].', idprof='.$tpid[$r].' - '.$tnomprof[$r].'&nbsp;'.$tprenomprof[$r].
				', accord='.$tacc[$r].', date='.$tdaterep[$r].$msupp."<br />\n";
	}
print "</p></fieldset>\n";
}


function verifdem($id) {
//les "global" sont :
//  - uniques et relatifs  la demande traite pour : 
//      eid=eleve_id, iid=item_id, $did=disc_id, nbaccetab, nbrefusetab, etid, datedem
//  - des tableaux pour les profs ventuels : 
//		tpid=prof_id, tacc=accord, tdaterep (ventuellement 1 seule ligne de NULL)

//le paramtre $id correspond au $oldmid du programme appelant
global  $eid,$iid,$did,$etid,$datedem,
		$nomelv,$prenomelv,$classeid,
        $trid,$tpid,$tacc,$tdaterep, $trepdel,$tnomprof,$tprenomprof,
        $nbaccetab,$nbrefusetab,
		$nometab,$codepostal,
		$bilan, $messages, //pour rendre global et visible dans les fonctions appeles
		$tdemcorrectes;
$nbrep=count($tpid);
$oldprof=0;
$dejaoui=0;$dejanon=0;
$bilan=0;
$messages='';
$trepdel=array();
for ($i=0 ; $i<$nbrep ; $i++) {
	$prof_id=$tpid[$i];
	$accord=$tacc[$i];
	$daterep=$tdaterep[$i];
	$reponse_id=$trid[$i];
	if ($oldprof==$prof_id) {
		//plusieurs rponses du mme prof
		//on jette sauf si NON puis OUI
		if ($accord) {
			//un mme prof ne peut donner 2 oui	
			if ($dejaoui) {
				//on vacue la rponse OUI antrieure ($dejaoui)
				$trepdel[]=$dejaoui; 
				// ------------------------------------- effacer(rponse $dejaoui)
				}
			else {
				$bilan++;
				if ($dejanon) $bilan++; //un NON devenu OUI donc +2
                //NB : les NON prcdent les OUI (voir requte)    				  
                }
			$dejaoui=$reponse_id; //pour prparer le prochain dans l'ordre chrono
			}
		else {
			//prof_id a rpondu NON. A-t-il dj rpondu NON ?
			if ($dejanon) {
				$trepdel[]=$dejanon;
				// ------------------------------------- effacer(rponse $dejanon)
				}
			else {
				$bilan--; 
				}			
			$dejanon=$reponse_id;
			}
		}
	else {
		//autre prof pour cette demande : tout rinitialiser sauf le bilan
		$dejaoui=($accord)? $reponse_id:0;
		$dejanon=($accord)? 0:$reponse_id;
		if ($accord) $bilan++; else $bilan--;
		$oldprof=$prof_id;
		}
	}
//affichages
//si on supprime (code='s'), on vite de lancer une suppression des rponses superflues
if ($nbrefusetab!=0 && $bilan<=-$nbrefusetab ) {
	//si nbrefusetab=0, l'tab accepte un nombre quelconque de refus
	//nombre de refus atteint : demande et rponses doivent tre supprims
	printdemrep($id,'s');
	return 1; //inutile de fouiller davantage
	//query("DELETE FROM demandes WHERE message_id=$id");
	//query("DELETE FROM reponses WHERE message_id=$id");
    }
$ret=0;
if ($bilan>=$nbaccetab) {
    //bilan correct et pas de resultat
	printdemrep($id,'a');
	$ret=1;
	}
if (count($trepdel)) {
	//il y a des rponses  supprimer pour incohrences (mais sans consquences
	//sur les rsultats ni la demande). On signale quand mme la mise en cohrence de la base.
	printdemrep($id,'r');
	$ret=1;
	}
if ($ret==0) {
	//pas d'anomalie dans la demande (et pas de rsultat bien que des rponses)
	if (debug) printbleu($id);
	$tdemcorrectes[]='('.$id.')';
	
	}
return $ret;
}

function supprimerDemRep($mid) {
global $t2suppdem;
if (debug) echo 'message=',$mid," (et ses rponses)  supprimer<br>";
else $t2suppdem[]=$mid;
}

function ajouterRes($eid,$iid,$did) {
global $t2ajoutres;
if (debug) echo "rsultat ($eid,$iid,$did)  ajouter<br>";
else $t2ajoutres[]="(NULL,NOW(),$eid,$iid,$did)";
}

function supprimerRep($message_id,&$trep) {
global $t2supprep;
foreach($trep AS $idx => $rep)  { 
	//slectionner les idx numriques
	if (is_int($idx)) {
		if (debug) echo ' rponse=',$rep,' du message=',$message_id,'  supprimer<br>';
		else $t2supprep[]=$rep;
		}
	}
}	


function depiler() {
global $t2suppdem, $t2ajoutres, $t2supprep;
if (count($t2suppdem)) {
	$liste=implode(',',$t2suppdem);
	query("DELETE FROM demandes WHERE message_id IN ($liste)");
	query("DELETE FROM reponses WHERE message_id IN ($liste)");
	}
if (count($t2ajoutres)) {
	$liste=implode(',',$t2ajoutres);
	query("INSERT IGNORE INTO resultats VALUES $liste");
	}
if (count($t2supprep)) {
	$liste=implode(',',$t2supprep);
	query("DELETE FROM reponses WHERE reponse_id IN ($liste)");
	}
}
	




	

//***************  Programme principal  *********************************************************************
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//***********************************************************************************************************

//----------------------------------------

print "<h2>Vrification des demandes / rponses</h2>";
print "<hr />";


//"""""""""""""""""""""""""""""""""""""""""
set_time_limit(600);
opensession('Sadmin',false);
if ($sess_login=='admstats') {
	aneantir_session();
	goto("./index.php");
	}
connecte($host, $user, $mdp,$db);
//"""""""""""""""""""""""""""""""""""""""""
//"constante" ou "paramtre  mettre dans les options" ou "champ  ajouter"
$nbdemparpage=100;

//if (isset($_REQUEST)) print_r($_REQUEST);


if (isset($go) && isset($tfdem)) {
	//le bouton submit a t utilis : traiter la purge de la page prcdente
	//empilent les actions pour optimiser les requtes
	$t2suppdem=$t2ajoutres=$t2supprep=array(); 
	foreach($tfdem as $message_id => $cause) { 
		if (isset($cause['s'])) 	supprimerDemRep($message_id);
		else {
			if (isset($cause['a'])) ajouterRes($cause['e'],$cause['i'],$cause['d']);
			if (isset($cause['r'])) supprimerRep($message_id,$cause);
			}
		}
	depiler();
	}	

$PHP_SELF=basename($_SERVER['PHP_SELF']);
/*
print "<p style=\"color:blue\"><i>En couleurs, les demandes avec rponse, sans rsultat et sans anomalie 
		(les autres ne sont pas analyses car l'lve ne risque pas tre ls)
		</i></p>";
*/

//supprimer un etable cre dans les versions prliminaires
if (table_dans_base('demverifiees',$db)) query("DROP TABLE IF EXISTS demverifiees");

if ($MODULE=='Melia') {
	$AND_discdem=" AND profs.disc_id=demandes.disc_id ";
	$AND_discres=" AND resultats.disc_id=demandes.disc_id ";
	}
else {
	$AND_discdem=' ';
	$AND_discres=' ';
	}

$sql="CREATE TABLE IF NOT EXISTS demok (
		message_id INT UNSIGNED NOT NULL ,
		UNIQUE (message_id)
		)" ;

$v=mysql_get_server_info();
if ($v[0]=='5') $sql.=" ENGINE = MYISAM ";

query($sql) ;

$sqldemandes="
	SELECT DISTINCT demandes.message_id AS mid,
                    demandes.eleve_id AS eid,
                    demandes.item_id AS iid,
                    demandes.disc_id AS did,
					demandes.quand AS datedem,
					reponses.reponse_id AS rid,  
					reponses.prof_id AS pid,
					reponses.quand AS daterep, 
					accord, 
					eleves.etab_id AS etid,
					eleves.nom AS nomelv,
					eleves.prenom AS prenomelv,
					eleves.classe_id,
					profs.nom AS nomprof,
					profs.prenom AS prenomprof,
					nb_validations,
					nb_max_refus,
					etablissements.nom AS nometab,
					codepostal

	FROM demandes
		LEFT JOIN demok ON demandes.message_id=demok.message_id
		LEFT JOIN reponses ON reponses.message_id = demandes.message_id
		LEFT JOIN profs ON profs.prof_id = reponses.prof_id 
				
		LEFT JOIN resultats ON resultats.eleve_id=demandes.eleve_id 
				AND resultats.item_id=demandes.item_id
				AND resultats.disc_id=demandes.disc_id 
	, eleves
	, etablissements
	WHERE eleves.eleve_id=demandes.eleve_id
		AND etablissements.etab_id=eleves.etab_id
		AND demok.message_id IS NULL
		AND reponses.prof_id IS NOT NULL 
		AND resultats.resultat_id IS NULL

	ORDER BY etid,mid,pid,daterep,rid";

// galit de dates, utiliser l'indice reponse_id dans la table pour conserver la chronologie
//on ne s'intresse pas aux demandes ayant abouti  un rsultat : elles ne prsentent pas de risque ni d'erreur, 
//mme s'il y a des incohrences dans les demandes / reponses. Et puis on ne va pas supprimer le rsultat !

//lancement de la requte
$res=query($sqldemandes);
$total=mysql_num_rows(query("SELECT * FROM demandes"));
$restant=mysql_num_rows($res);
print "<p><i>Nombre total de demandes en cours : $total<br />";
print "Nombre de demandes restant  vrifier : $restant</i></p>";
if ($restant==0) {
    print "<h3>Pas d'incohrence dans les demandes / rponses</h3>";
    print "<a href=\"choix_verif.form.php\">Revenir aux vrifications</a>\n";
	print "</body></html>";
	exit();
	}
$nbpages=(int) $restant / $nbdemparpage;
if ($restant % $nbdemparpage) $nbpages++;

if (!isset($numpage)) $numpage=1;
if ($numpage>$nbpages) $numpage=$nbpages;
$offset=($numpage-1)*$nbdemparpage;
if ($offset+1>$restant) $offset=$restant-1;

echo "<p><br /><b>Choisir la page  visualiser : </b>";
for ($page=1; $page<$nbpages; $page++) {
	$lien=" <a href=\"$PHP_SELF?numpage=$page\" >$page</a>\n";
	if ($page==$numpage) {
		print "<span style=\"margin: 0;padding:0;border-style:solid;width:4px;text-align:center;border-width: thin;border-color: Blue;\">";
		print $lien;
		print "</span>\n";	
		}
	else print $lien;
	print "&nbsp;&nbsp;&nbsp;";
	}
echo "</p>";
 
echo "<form name=\"form1\" action=\"$PHP_SELF\" method=\"post\">\n"; 
//echo "<input type=\"hidden\" name=\"offset\" value=\"$offset\" />\n";
//fournir le numro de page affich au script rcepteur
echo "<input type=\"hidden\" name=\"numpage\" value=\"$numpage\" />\n";
print "<p>&nbsp</p>\n";
if ($restant) {
	echo "<p align=\"center\">\n";
	echo "<input type=\"submit\" name=\"go\" value=\"  Traiter les lments cochs de cette page\n comme il est suggr ci-dessous \"/><br />";
	echo "</p>\n";
	}

$nbverifs=0;
$tdemcorrectes=array();
mysql_data_seek($res,$offset);

$row=mysql_fetch_array($res);
while ($row && $nbverifs<$nbdemparpage) {
	//initaliser ou rinitialiser les stockages de la requte
	$mid=$row['mid'];
	$oldmid=$mid;
	$eid=$row['eid'];
	$iid=$row['iid'];
	$did=$row['did'];
	$datedem=$row['datedem'];
	$etid=$row['etid'];
	$nomelv=$row['nomelv'];
	$prenomelv=$row['prenomelv'];
	$classeid=$row['classe_id'];
	$nometab=$row['nometab'];
	$codepostal=$row['codepostal'];
	$nbaccetab=$row['nb_validations'];
	$nbrefusetab=$row['nb_max_refus'];
	$trid=$tpid=$tacc=$tdaterep=$tnomprof=array();
	do  {
		//stocker la rponse
		$trid[]=$row['rid'];
		$tpid[]=$row['pid'];
		$tacc[]=$row['accord'];
		$tdaterep[]=$row['daterep'];
		$tnomprof[]=$row['nomprof'];
		$tprenomprof[]=$row['prenomprof'];
		$row=mysql_fetch_array($res);
		}
	while ($row && $row['mid']==$mid);
	$verif=verifdem($mid);
	if ($verif) $nbverifs++; //on ne compte que les demandes anormales  
	}						
//print "DemCorrectes : ";print_r($tdemcorrectes);print "<br>";
if (count($tdemcorrectes)) {
	//stocker les demandes correctes trouves (demandes "bleues") pour ne pas les rafficher
	$liste=implode(',',$tdemcorrectes);
	query("INSERT INTO demok VALUES $liste");
	}
	
?>
</form>
</body>
</html>
