<?php
#=
/****************************************************************************
Copyright 2002, Daniel Deycard, Jacques Messines, Stphanie Roussel, Jean-Marie Treins
(CATICE Acadmie de Bordeaux)

This file is part of GiBii/Melia.

GiBii/Melia is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

GiBii/Melia is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GiBii/Melia; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/

//============  Constantes et variables  ajuster ===========//
//              """""""""""""""""""""""""""""""""			 //
define("REP_GIBII","../");
define("REP_DATA",REP_GIBII."data/sadmin/batch/");
define("REP_LOG",REP_GIBII."data/sadmin/");
$verbose=false; // true : affiche les dtails de l'incorporation de chaque tab comme avec l'admin 
				// conseill : false (ralentit l'excution).
//Dans tous les cas, le fichier log contient les "titres" (RNE et compte rendu).
//===========================================================//

include(REP_GIBII."include/vars_adm.php");
include(REP_GIBII."include/util.inc.php");
include(REP_GIBII."include/utiljs.php");
include(REP_GIBII."incorporation/individus.class.php");
include(REP_GIBII."incorporation/importation.php");

//////////////////////////////////////////////////////////////////////////

function logf($m) {
global $flog;
print nl2br($m);
fwrite($flog,$m);	
}

function stocker($m='') {
static $ix=-1;
global $tfic,$file,$rne,$incor;
$ix++;
$tfic[$ix]['rne']=$rne;
$tfic[$ix]['incor']=$incor;
$tfic[$ix]['file']=$file;
$tfic[$ix]['mess']=$m;
}

function writemsg($tresult,$qui) {
global $rne;
list($cr1,$cr2)=$tresult;	
if ($cr1<0) logf(get_errmsg($cr1)); //dans importation ; n'agit que si cr1<0
else {
	logf("===== $rne - $qui traits : $cr2 -- Incertains : $cr1\n"); 
	}
logf("\n");
}


//////////////////////////////////////////////////////////////////////////
?><!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
<title>Menu sadmin</title>
<link rel="stylesheet" href="../include/general.css" />
<base target="_self" />
</head>
<body class="arial_sadmin" bgcolor="white" text="black" link="blue" vlink="purple" alink="red">

<?php
creertousrep(REP_LOG);
creertousrep(REP_DATA);
connecte($host,$user,$mdp,$db);
getparams(false); 

//variables globales dfinies pour l'admin
if ($IMPOSE_CHGT_MDP) $champactif=0; else $champactif=1;
$fichierele='';$fichierwind='';$fichiermen='';
$fichiereleves=''; //redfini dans la boucle
$fichierprofs='';
$incorele=$incorwind=$incormen=0;
$purgefic=1;
$typefic='txt';
$razlogin=0;$razmdp=0;$logfournis=0;$mdpfournis=0;$razlog=0;
$sess_ascol=ascol();

$date=date("Ymd_His");
$dir_bak=REP_DATA.$date.'/'; 	// un sous-rpertoire par excution
$fic_log=REP_LOG."!incorp_$date.log";

$flog=fopen($fic_log,"w");

logf("===============================================\n");
logf("Batch d'incorporation commenc le ".date("D d F Y H:i:s")."\n");
logf("===============================================\n");


$tfic=array(); //il faut conserver les fichiers pour un tri spcial
if (is_dir(REP_DATA)) { 
    if ($dh = opendir(REP_DATA)) {
        while (($file = readdir($dh)) !== false) {
			$fichier=REP_DATA.$file;
            if (filetype($fichier)=="dir") 
				continue;
            $rne=mysql_escape_string(substr(strrchr($file,"."),1));
            if (!preg_match("/\d{7}[a-z]/i", $rne)) {
				stocker("RNE ($rne) incorrect !");
				continue;
				}
			$incor=strtolower(substr($file,0,1));
			if ($incor!='e' && $incor!='p') {
				stocker("le dbut du nom du fichier ($file) ne commence ni par 'e' ni par 'p'.");
            	continue;
            	}
			if (mysql_num_rows(query("SELECT * FROM etablissements WHERE rne='$rne'"))==0) {
				stocker("Etablissement $rne inexistant dans la base.");
				continue;
				}
			stocker(); //cas utilisable	
			}
		
		$trne=array();
		$tincor=array();
		
		//trier $tfic en fonction des rne et individus
		foreach($tfic as $key => $ligne) { //crer les tableaux des colonnes  trier
			$trne[$key]=$ligne['rne'];
			$tincor[$key]=$ligne['incor'];
			}		
		array_multisort($trne,$tincor,$tfic); //tfic est tri par rne / incor
		
		//balayer les lments de tfic
		
		for ($itfic=0 ; $itfic<count($tfic) ; $itfic++) {
			$rne=$tfic[$itfic]['rne'];
			$incor=$tfic[$itfic]['incor'];
			$file=$tfic[$itfic]['file'];
			$mess=$tfic[$itfic]['mess'];
			
			$fichier=REP_DATA.$file;
			$incoreleves=($incor=='e');
			$incorprofs=($incor=='p');
			
			logf("##### RNE : <$rne> -- fichier : $file ");
			if ($mess) {
				logf(' -> '.$mess."\n");
				continue;
				}
			logf("\n");
			
			$retab=query("SELECT * FROM etablissements WHERE rne='$rne'");
			$rowetab=mysql_fetch_array($retab);

			//traitement d'un tab
			//====================
			$etab_id=$rowetab['etab_id'];
			getparams_etab($etab_id);
			if ($incoreleves) {
				query("DELETE FROM eleves WHERE (tag>=1 OR compte_id IS NULL) AND etab_id=$etab_id"); //anciens incertains qui trainent
				if (table_dans_base('divers',$db)) query("DELETE FROM divers WHERE etab_id=$etab_id AND motcle='eleves'");
		   		$modele=$etab_modele_login_e;
	    		$tresult=balayer_txt('eleve',$fichier,true,$verbose);
				$qui='Elves';
				}
			else {
				query("DELETE FROM profs WHERE (tag>=1 OR compte_id IS NULL) AND etab_id=$etab_id"); //anciens incertains qui trainent
				if (table_dans_base('divers',$db)) query("DELETE FROM divers WHERE etab_id=$etab_id AND motcle='profs'");
		   		$modele=$etab_modele_login_p;
	    		$tresult=balayer_txt('prof',$fichier,true,$verbose);
	    		$qui='Profs';
				}
			writemsg($tresult,$qui);
			@mkdir($dir_bak); //on ne cre que s'il y a de la matire
        	rename($fichier,$dir_bak.$file);
        	}
        closedir($dh);
    	}
    else stocker("Impossible d'accder au rpertoire ".REP_DATA);
	}
else stocker(REP_DATA." n'est pas un rpertoire !");

logf("\n-----------------------------------\n");
logf("Termin le ".date("D d F Y H:i:s")."\n");
logf("-----------------------------------\n");
fclose($flog);
voircetendroit();
?>
</body></html>
