<?php
#=
/****************************************************************************
Copyright 2002, Daniel Deycard, Jacques Messines, Stphanie Roussel, Jean-Marie Treins
(CATICE Acadmie de Bordeaux)

This file is part of Gibii.

Gibii is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Gibii is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Gibii; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/
//on dbarque avec les paramtres ventuels suivants dans l'URL :
// - ordre=date sens=asc         : nouveaux paramtres (ordre de premier niveau)
// - ordreold=nom sensold=desc   : anciens paramtres (ordre de deuxime niveau)

include("../include/vars_adm.php");
include("../include/util.inc.php");
include("../include/utiljs.php");
include("bilan.inc.php");
include("../include/purges.inc.php");

//ouverture de la session
opensession("Prof",false);
$PHP_SELF=basename($_SERVER['PHP_SELF']);
print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n";
?>

<html><head>
<meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
<title>Page profs</title>
<script language="JavaScript">
var liste_images = new Array('btn_val_ok','btn_val_no','i','non');
// Un tableau qui permettra le stockage 'virtuel' des images pour les precharger
document.image_chargee = new Array();
// La fonction de prechargement

function prechargement(chemin) {
        for ( i = 0; i < liste_images.length; i++ ) {
                document.image_chargee[i] = new Image;
                document.image_chargee[i].src = chemin + liste_images[i] + '.gif';
                }
    //alert('images charges');
}

var fen;   //cre dans la function getpop, utilise dans body.onfocus
var fen_exist=false;  //permet de savoir si fen a dj t affecte (test du body.onfocus)

function getpop(cible,w,h,l,t) {
   var param='width='+w+',height='+h+',left='+l+',top='+t+',status=0,directories=0,toolbar=0,menubar=0,location=0,scrollbars=1,resizable=1';
   fen=window.open(cible,'vasydefonce',param);
   fen_exist=true;
   window.fen.focus();
}

function focusestla() {
   if (fen_exist) {
       if (fen.closed) fen_exist=false;
       else fen.focus();
   }
}

</script>

<link rel="stylesheet" href="<?php echo "../themes/".$etab_theme."/b2i.css" ?>">

<!--[if lt IE 7]> <script  src="../include/fixed.js" type="text/javascript"></script> <![endif]-->
<!-- ncessaire pour les version 5   6 de IE pour muler l'attribut fixed.-->

<style type="text/css">
img#retour{
  position:fixed;
  right:10px;
  bottom:10px;
}
</style>
<!-- bien que ce style pour la flche de retour soit dans la CSS, IE7 ne l'interprte pas et il l'accepte s'il est l ????-->
</head>
<?php

$chem_images="../themes/".$etab_theme."/";
print "<body class=\"arialprof\"
             bgcolor=\"white\" text=\"black\" link=\"blue\" vlink=\"purple\" alink=\"red\"
             onload=\"javascript:prechargement('$chem_images');\"
             onfocus=\"javascript:focusestla();\">\n";

//la flche de retour en haut de page
//-----------------------------------
print "<a href=\"#haut_de_page\"><img id=\"retour\" src='../themes/".$etab_theme."/retour.gif' border='0' title ='Retour en haut de page'></a>";
print "<a name=\"haut_de_page\"></a>\n";

function fleches($nomchamp,$hint) {
//nomchamp peut valoir date, nom, prenom
global $PHP_SELF,$etab_theme,
       $ordre,$sens; //les "futurs anciens" paramtres (c'est  dire ceux de ce passage)
    print "<br />\n";
    //prparer la nouvelle demande en gardant l'ancienne en 2me niveau

    //flche ascendante
    if ($ordre==$nomchamp && $sens=="asc") $img="iv"; //inversion vido pour l'image slectionne
    else $img="";
    print "<a href=\"$PHP_SELF?ordre=$nomchamp&sens=asc&ordreold=$ordre&sensold=$sens\">";
    print "<img src=\"../themes/".$etab_theme."/bas$img.gif\" width=\"17\" height=\"17\" alt=\"tri croissant des $hint\" border=\"0\">";
    print "</a>";

   // sparateur de flches
    print "<img  border='0' width='15' src=\"../images/pixel_vide.gif\">";

    //flche descendante
    if ($ordre==$nomchamp && $sens=="desc") $img="iv"; //inversion vido pour l'image slectionne
    else $img="";
    print "<a href=\"$PHP_SELF?ordre=$nomchamp&sens=desc&ordreold=$ordre&sensold=$sens\">";
    print "<img src=\"../themes/".$etab_theme."/haut$img.gif\" width=\"17\" height=\"17\" alt=\"tri dcroissant des $hint\" border=\"0\" />\n";
    print "</a>";

}


function selif($a,$b) {
//if (((string) $a)== ((string) $b)) $ret=" selected=\"selected\" "; 
if (!(strcmp($a,$b))) return " selected=\"selected\" "; 
else return "";
}


//modifie le buffer de sortie en affichant d'abord les combo-boxes
function callback_modbuf($buffer) {
global $tabclasses,$tabnoms,$tabitems,
       $sel_date,$sel_classe,$sel_nom,$sel_comment,$sel_item,
       $PHP_SELF;

//$combo= "########  $sel_date,$sel_classe,$sel_nom,$sel_comment,$sel_item<br>";
$combo='';
sort($tabnoms);sort($tabclasses);sort($tabitems);
$combo.="<tr class=\"rubrique\"><td> &nbsp; </td> <td>\n";

//date
$selected=array_fill(0,6,'');
$selected[$sel_date]=" selected=\"selected\" ";
$combo.="<select name=\"sel_date\" size=\"1\" id=\"sel_date\" onchange=\"submit();\">
          <option value=\"0\" $selected[0]>toutes</option>
          <option value=\"1\" $selected[1]>ce jour</option>
          <option value=\"2\" $selected[2]>- de 8 j</option>
          <option value=\"3\" $selected[3]>- de 15 j</option>
          <option value=\"4\" $selected[4]>+ de 15 j</option>
          <option value=\"5\" $selected[5]>+ de 21 j</option>
        </select></td>
      <td>\n";

//classe
$combo.="<select name=\"sel_classe\" size=\"1\" id=\"sel_classe\" onchange=\"submit();\">\n
          <option value=\"0\" ".selif($sel_classe,'0').">toutes</option>\n";
foreach($tabclasses as $uneclasse) {
    $combo.="<option value=\"$uneclasse\" ".selif($uneclasse,$sel_classe).">$uneclasse</option>\n";
    }
$combo.= "</select></td><td>&nbsp;</td><td>\n";

//nom
$combo.="<select name=\"sel_nom\" size=\"1\" id=\"sel_nom\" onchange=\"submit();\">
          <option value=\"0\" ".selif($sel_nom,'0').">tous</option>\n";
foreach($tabnoms as $unnom) {
    $combo.= "<option value=\"$unnom\"".selif($sel_nom,$unnom).">$unnom</option>\n";
}
$combo.= "</select></td><td>\n";

//commentaire
unset($selected);
$selected=array_fill(0,3,'');
$selected[$sel_comment]=" selected=\"selected\" ";
$combo.="<select name=\"sel_comment\" size=\"1\" id=\"sel_comment\" onchange=\"submit();\">\n
          <option value=\"0\"".$selected[0].">tous</option>\n
          <option value=\"1\"".$selected[1].">prsents</option>\n
          <option value=\"2\"".$selected[2].">absents</option>\n
        </select></td><td>\n";

//numro d'item

$combo.="<select name=\"sel_item\" size=\"1\" id=\"sel_item\" onchange=\"submit();\">\n
          <option value=\"0\" ".selif($sel_item,'0').">
           tous&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
          </option>\n";
foreach($tabitems as $unitem) {
    $combo.= "<option value=\"$unitem\"".selif($sel_item,$unitem).">$unitem</option>\n";
}

$combo.="</select>\n</td></tr>\n";
return $combo.$buffer;
}

//------------

function filtre_requete($sel_date,$sel_classe,$sel_nom,$sel_comment,$sel_item) {
$result="";

//sel_date
$prefixe=" and TO_DAYS(NOW()) - TO_DAYS(demandes.quand) ";
switch ($sel_date) {
    case 1 : $result.=$prefixe."=0 ";  break;
    case 2 : $result.=$prefixe."<=8 "; break;
    case 3 : $result.=$prefixe."<=15 ";break;
    case 4 : $result.=$prefixe.">15 "; break;
    case 5 : $result.=$prefixe.">21 "; break;
        }
//sel_classe
if ($sel_classe!="0") $result.=" and classes.divcod='$sel_classe' ";
//sel_nom
if ($sel_nom!="0") $result.=" and eleves.nom='$sel_nom' ";
//sel_comment
if ($sel_comment==1) $result.=" and demandes.commentaire<>'' ";
elseif ($sel_comment==2) $result.=" and demandes.commentaire='' ";
//$sel_item
if ($sel_item!="0") $result.=" and demandes.item_id='$sel_item' ";
//print "$sel_date,$sel_classe,$sel_nom,$sel_comment,$sel_item";
return $result;
}

/////////////////////////
// programme principal //
/////////////////////////

//print "Au dbut : variables sel_*=$sel_date,$sel_classe,$sel_nom,$sel_comment,$sel_item<br>";

/*
On vient d'endroits varis...
   -1- le login d'un prof (login_traite.php)
   -2- l'appui sur une flche de tri,
   -3- la modification d'un filtre
   -4- le retour du traitement d'une rponse (accord ou refus)
Les cas 2, 3 et 4 ncessitent la rcupration des paramtres de tri et de
filtre. Ces paramtres sont en variables de session lorsqu'ils n'ont pas t
modifis par la page prcdente.
Pour le cas 3 par exemple, un choix d'un filtre sur la classe va modifier
la variable $sel_classe qu'on va rcuprer en POST.
Mais la rcupration des variables de session est faite de telle faon
qu'elle crase les POST et GET et donc $sel_classe par une valeur plus ancienne,
ceci afin de respecter l'ordre EGPCS. Par suite, aprs l'ouverture de la session,
on rcupre les ventuelles variables des tableaux _POST et _GET contenant les
variables passes par formulaire (cas 2) ou par l'URL (cas 3).

De plus, lorsqu'on entre pour la premire fois dans le script (cas 1) il faut
enregistrer des valeurs par dfaut pour les variables de session.
*/

//opensession a rcupr d'abord les GET et les POST puis les variables de session.
//Or ICI, pour une fois, les GET et POST doivent avoir priorit. Il faut donc rectifier
// attention : a ne donnera pas les rsultats escompts avec un trop vieux PHP (<4.0.4 je crois)
//car les variables de POST par exemple seront globalises au niveau 0 et non au niveau de cette fonction

//$tempsdebut=getmicrotime();

//est-ce qu'on vient d'un choix de filtre
if (count($_POST))  { //on vient du formulaire : les variables POST ont priorit sur session
    if (isset($_POST['sel_date'])) $sel_date=$_POST['sel_date'];
    if (isset($_POST['sel_classe']))$sel_classe=$_POST['sel_classe'];
    if (isset($_POST['sel_nom'])) $sel_nom=$_POST['sel_nom'];
    if (isset($_POST['sel_comment'])) $sel_comment=$_POST['sel_comment'];
    if (isset($_POST['sel_item'])) $sel_item=$_POST['sel_item'];
    session_puts("sel_date","sel_classe","sel_nom","sel_comment","sel_item");
}
//est-ce qu'on vient d'une demande de tri
elseif (count($_GET))    { //on vient de modifier un ordre
    $ordre=$_GET['ordre'];
    $sens=$_GET['sens'];
    $ordreold=$_GET['ordreold'];
    $sensold=$_GET['sensold'];
}

$prof_id=$sess_mec_id;

//cas du premier passage dans ce script
if (isset($_SESSION['ordre'])) $session_ordre=$_SESSION['ordre'];
else $session_ordre='';

if (empty($session_ordre)) {  //le test d'une seule variable suffit
    $ordre="quand";
    $sens="desc";
    if ($_SESSION['sess_opt_dem1an']) $sel_date=3; else $sel_date=0; //pour limiter l'affichage
    session_puts("ordre","sens","ordreold","sensold");
    $sel_classe=$sel_nom=$sel_comment=$sel_item=0;
    session_puts("sel_date","sel_classe","sel_nom","sel_comment","sel_item");
    }

//prparer le bout de requte relatif  l'ordre
if (!isset($ordre)) $ordre="quand";
if (!isset($sens)) $sens="desc";
if (!isset($sel_date)) $sel_date="0";
if (!isset($sel_classe)) $sel_classe="0";
if (!isset($sel_nom)) $sel_nom="0";
if (!isset($sel_comment)) $sel_comment="0";
if (!isset($sel_item)) $sel_item="0";

$orderby=" ORDER BY $ordre $sens ";
if (!empty($ordreold)) $orderby.=", $ordreold $sensold";

//prparer le bout de requte relatif aux filtres
$where_filtre=filtre_requete($sel_date,$sel_classe,$sel_nom,$sel_comment,$sel_item);
//print "Requte : $where<br>";
print "<br /><font size='-1' ><i>".LISTE_MESS_COURS."</i><br></font><br />";


if ($MODULE=='Melia') {    
      $cond_disc_dem=" AND demandes.disc_id=$disc_id ";
    $cond_disc_res=" AND resultats.disc_id=$disc_id ";
    }
else {
      $cond_disc_dem='';
    $cond_disc_res='';
    }

/*
demandes destines au prof P telles que :
    - elles s'adressent  P (via prof_id --> [lpc, lec] --> eleve_id)
    - P est comptent
    - elles n'ont pas abouti  un rsultat 
    - P n'y a pas rpondu ou a rpondu non

NB : active=1 implique obtenue=0. Donc pas la peine de faire intervenir les rsultats.
On peut obtenir une demande active alors qu'elle est prime (le temps s'coule sans prvenir le script...
La fonction gerer_duree s'occupe de ce problme
*/
$sqldemandes="
    SELECT DISTINCT
            demandes.message_id,
            demandes.eleve_id,
            demandes.quand,
            demandes.commentaire,
            demandes.item_id,
            nboui, nbnon, longue,
            reponse_id,
            accord,
            eleves.eleve_id,
            eleves.nom,
            eleves.prenom,
            libelles.base,
            classes.divcod
    FROM    eleves, lpi, libelles, lien_profs_classes, lien_eleves_classes, classes, demandes
    LEFT JOIN reponses ON reponses.message_id = demandes.message_id
        AND reponses.prof_id =".$prof_id."
    WHERE lpi.prof_id =".$prof_id."
        AND lien_profs_classes.prof_id =".$prof_id."
        AND lien_profs_classes.classe_id = lien_eleves_classes.classe_id
        AND lien_eleves_classes.classe_id=classes.classe_id
        AND lien_eleves_classes.eleve_id = demandes.eleve_id
        AND demandes.item_id = lpi.item_id"
        .$cond_disc_dem."
        AND demandes.eleve_id = eleves.eleve_id
        AND lpi.item_id = libelles.item_id
        AND active=1
        AND (reponses.reponse_id IS NULL OR reponses.accord =0)"
        .$where_filtre
        .$orderby;


//print nl2br($sqldemandes); exit();
$resdemandes=query($sqldemandes);

//on va attribuer un ID numrot  chaque ancre + image pour l'affichage des demandes
//grce  cet ID, on pourra faire disparatre l'image-bouton et virer le lien.

$dem=0;  //compteur de cet ID
print "<form name=\"formfiltre\" method=\"post\" action=\"$PHP_SELF\">\n";
print "<table>\n"; //cellspacing=\"0\" va-t-il mieux ?
// au choix : print "<table border=\"0\" CELLSPACING=\"1\" CELLPADDING=\"2\">\n";
print "<tr class='rubrique'>\n";
print "<td width=\"100\">Traiter<br>la demande</td>\n";
print "<td>Date";fleches("quand","dates");print "</td>\n";
print "<td>Classe";fleches("divcod","classes");print "</td>\n";
print "<td>Prnom";fleches("prenom","prnoms");print "</td>\n";
print "<td>Nom";fleches("nom","noms");print "</td>\n";
print "<td>Message<br>&nbsp;</td>\n";
print "<td>Item<br>&nbsp;</td>\n";
print "</tr>";

$liste_message_id="";  //en rserve pour une validation globale... plus tard.
$tabclasses=array();$tabnoms=array();$tabitems=array();
ob_start("callback_modbuf");


@setlocale(LC_TIME, "fr_FR", "FRA", 'france', 'french');

$tmid=array();  //conservera les message_id rencontrs pour viter les doublons
                //dus  la double appartenance (classe et groupe).
$cumulsqlrep1=$cumulsqlrep2=$cumulsqliacq=0;

while ($rowdem=mysql_fetch_array($resdemandes)) {
    $message_id =$rowdem["message_id"];
    if (in_array($message_id,$tmid)) continue;

    $eleve_id   =$rowdem["eleve_id"];
    $item_id    =$rowdem["item_id"];
    $libelle    =$rowdem["base"];
    $classe     =$rowdem['divcod'];
    $date       =$rowdem["quand"];
    $nom        =$rowdem["nom"];
    $prenom     =$rowdem["prenom"];
    $nbacc      =$rowdem["nboui"];
    $nbrefus    =$rowdem["nbnon"];
    $longue     =$rowdem["longue"];
    
    $comment=htmlspecialchars($rowdem["commentaire"]);

    //s'il y a une rponse, c'est un refus, du fait de la condition :
    //  reponses.reponse_id IS NULL OR reponses.accord =0 de la requte
    if (isset($rowdem['reponse_id'])) $reponse_id=$rowdem['reponse_id'];
    else $reponse_id=0;
    //donc reponse_id=876 indique que le prof a rpondu non antrieurement
    
    $bilan=$nbacc-$nbrefus;
    $nj=(int) ((strtotime("now")-strtotime($date))/86400);
    if (!onVientDeLaMemePage() 
        && 
        est_inactivee($message_id,$eleve_id,$item_id,$disc_id,$nj,$nbrefus,$nbacc,$longue)) 
        {
        //la demande a t dsactive ou supprime
        //test uniquement lors du premier passage 
        //(en fait non test  lors d'un 2e passage conscutif).
        continue;
        }

    //La demande doit tre affiche
    //-----------------------------
    $tmid[]=$message_id;
    $dem++;

    //stockage pour affichage des combo-boxes
    if (!in_array($nom,$tabnoms)) $tabnoms[]=$nom;
    if (!in_array($classe,$tabclasses)) $tabclasses[]=$classe;
    if (!in_array($item_id,$tabitems)) $tabitems[]=$item_id;

    //couleur de la ligne suivant sa parit
    $cl=($dem%2==0) ? "dem_paire" : "dem_impaire";
    print "<tr class='$cl'>\n";

    $liste_message_id.="$message_id,";

    //colonne 0 : les boutons pour la demande
    //---------------------------------------
    print "\t<td>";
    //dans l'URI, seul le paramtre prechoix diffre pour les "bouton" oui et non

    //col 0 :affiche le premier bouton (oui)
    //""""""""""""""""""""""""""""""""""""""

    //dd 04/2006 sont recalculs dans l'URL de destination :
    //date, prenom, nom, comment, libelle, rubrique
    //sont envoys par l'URL :
    //message_id,id_rep_non,eleve_id,item_id,classe,bilan,nbrefus,dem,prechoix
    $target="demande_traite.php?message_id=$message_id&id_rep_non=$reponse_id".
            "&eleve_id=$eleve_id&item_id=$item_id&classe=".urlencode($classe).
            "&dem=$dem"; //pour connatre les ID des lments depuis demande_traite.php
    $targetoui=$target."&prechoix=1";
    if ($etab_pop_profs==1) {
        //on met un div pour faire effacer ventuellement le tag <a> par un js
        print "<span id=\"tagaoui$dem\">";
        print "<a href=\"javascript:void(0)\" id=\"lienoui$dem\" onClick=\"getpop('$targetoui',700,420,50,50)\">";
        }
    else { //Affichage classique avec rafrachissement
        print "<a href=\"$targetoui\">\n";
        }
    print "<img id=\"imgoui$dem\" align=\"absmiddle\" border='0' width='20' height='20' title=\"Accepter l'item\" src=' ../themes/".$etab_theme."/btn_val_ok.gif'>";
    print "</a>\n";
    if ($etab_pop_profs==1) print "</span>\n";
    
    // col 0 : affiche le deuxime bouton pour Non
    //""""""""""""""""""""""""""""""""""""""""""""
    $targetnon=$target."&prechoix=0";
    if ($reponse_id) { //on n'affiche pas de bouton NON s'il a dj rpondu non
        print "<img align=\"absmiddle\" border='0' width='20' height='20' title=\"Dj refus !\" src=\"../images/pixel_vide.gif\">";
        }
    else {
        if ($etab_pop_profs==1) { //Mode popup
            print "<span id=\"taganon$dem\">";
            print "<a href=\"javascript:void(0)\" id=\"liennon$dem\" onClick=\"getpop('$targetnon',700,420,50,50)\">";
            }
        else { //Mode normal
            print "<a href=\"$targetnon\">";
            }
        print "<img id=\"imgnon$dem\" align=\"absmiddle\" border='0' width='20' height='20' title=\"Refuser l'item\" src='../themes/".$etab_theme."/btn_val_no.gif'>";
        print "</a>";
        if ($etab_pop_profs==1) print "</span>\n";
        }

    // col 0 : un lien vers l'affichage en popup des copains concerns par le mme message
    //""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
    if (($MODULE!='Melia') || ($etab_nb_validations>1) ) {
        $target="pop_profs_possibles.php?eleve_id=$eleve_id&item_id=$item_id".
                "&message_id=$message_id&prof_id0=$prof_id".
                "&nom=".urlencode($nom)."&prenom=".urlencode($prenom);
        print "<a href=\"javascript:void(0)\"  onClick=\"getpop('$target',600,300,150,50)\">";

        if  ($nbrefus!=0) {$info="irouge"; $fin_title=" ; il existe des refus";} else {$info="i";$fin_title="";} // on affiche une icone info prof validateurs de couleur rouge si refus

         print "<img width='20' height='20' border='0' align=\"absmiddle\" src=\"../themes/".$etab_theme."/".$info.".gif\" title=\"Autres enseignants concerns".$fin_title.".\">";
        print "</a>&nbsp;";
        }

    if ($reponse_id) {
        // col 0 : une ventuelle croix rouge indiquant un ancien refus
        //"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
        print "<img src=\"../themes/".$etab_theme."/non.gif\"
                    id=\"croix$dem\"
                    align=\"absmiddle\"
                    width=\"20\"
                    height=\"20\"
                    border=\"0\"
                    title=\"Dj rpondu non !\">";
    }
    else {
        //col 0 : ou une zone vide pour maintenir l'alignement de la suite (jmt)
        //""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
        print "&nbsp;<img src=\"../images/pixel_vide.gif\"
                    id=\"croix$dem\"
                    align=\"absmiddle\"
                    width=\"20\"
                    height=\"20\"
                    border=\"0\"
                    title=\"\">";
    }

    print "\n\t</td>";

    //colonne 1 : la date de demande
    //------------------------------
    print "\t<td align=\"center\">&nbsp;&nbsp;";
    //print strftime('%a %d %b %Y  %H:%M:%S',strtotime($date));
    print strftime(' le %d-%m-%Y  %H:%M:%S',strtotime($date));
    //date('d/m/Y  H:i:s',strtotime($date));
    print "\n\t</td>";

    //colonne 2 : classe id ?
    //-----------------------
    print "\t<td style :margin-left=\"10\";>";
    print $classe;
    print "\n\t</td>";

    //colonne 3 : prnom de l'lve
    //-----------------------------
    print "\t<td>&nbsp;&nbsp;";
    print $prenom;
    print "\n\t</td>";

    //colonne 4 : nom de l'lve
    //--------------------------
    print "\t<td>&nbsp;&nbsp;";
    print $nom;
    print "\n\t</td>";

    //colonne 5 : texte message
    //-------------------------
    print "\t<td>&nbsp;&nbsp;";
    print $comment;
    print "\n\t</td>";

    //colonne 6 : le texte de l'item
    //------------------------------
    print "\n\t<td><p class=item>";
    print "[$item_id] - $libelle";
    print "\n\t</p></td></tr>";
    }
print "</table>\n";
print "</form>\n";
// sortir la dernire virgule
if ($liste_message_id) $liste_message_id=substr_replace($liste_message_id,"",-1,1);

ob_end_flush();


?>

<p>&nbsp;</p>
</body>
</html>