<?php
#=
/****************************************************************************
Copyright 2002, Daniel Deycard, Jacques Messines, Alain Pomirol
(CATICE Acadmie de Bordeaux)

This file is part of GiBii/Melia.

GiBii/Melia is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

GiBii/Melia is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GiBii/Melia; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/
/* format du fichier import sur un exemple :
CLG Gambetta                          nom tab
                                      ligne vide
+                                     un nouvel lve
M.,Dargaud,Rgis,dnaiss               civil,nom, prnom ,dnaiss
i                                     code signalant qu'un item suit
12,2001-12-14 13:12:10                nitem,date
i                                     un nouvel item
14,2001-12-14 13:12:10
...
+                                     un nouvel lve
Einstein, Albert
i
22,2002-12-14 13:12:10
i
...
+                                     un nouvel lve
...
=                                     fin des lves
code                                  code de contrle
...                                   texte quelconque ventuel : non pris en compte
*/

include("../include/vars_adm.php");
include("../include/util.inc.php");
include("../include/utiljs.php");
require_once("../include/creerlogin.inc.php");
require_once("../include/define.inc.php");

opensession("Admin",false);
if ($PAS_IMPORT_EXPORT) {
    alert("Cette possibilit a t dsactive\npar le super-administrateur de GiSCCo");
    exit();
}

function entete() {
    global $etab_theme;
    print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n";
?>
<html><head>
<meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
<title>Importation d'items</title>
<link rel="stylesheet" href="<?php echo "../themes/".$etab_theme."/b2i.css" ?>">
<!-- Supprim sans tre supprim... A quoi servait javascript ???
<script language="javascript">
    function clic() {
    var frm=document.formulaire;
    //on ne peut pas invoquer les checkboxes par leur nom du fait des crochets utiles  PHP
    for (i=0;i < frm.elements.length; i++) {  //> pour la coloration
       if (frm.elements[i].type=='checkbox') {
               frm.elements[i].checked=!frm.elements[i].checked ;
               alert('name='f+frm.elements[i].name);
       }
    }
    return true;
    }
</script>
-->
</head>
<body class="arialadmin" bgcolor="white" text="black" link="blue" vlink="purple" alink="red">
<p class='sous_titre'>Importation d'items d'un autre tablissement</p>
<?php
//fin entete
}

function queue() {
print "</body></html>\n";
}

function printligne($col1,$col2) {
print "<tr>\n";
print "<td><p>$col1</p></td>\n";
print "<td><p> : $col2</p></td>\n";
print "</tr>\n";
}

function creer_table() {
global $table;
//Crer une table temporaire pour stocker les ambigus.
return  query( "CREATE TABLE IF NOT EXISTS $table(
                conserve_id INT NOT NULL AUTO_INCREMENT,
                nom VARCHAR(30) NOT NULL,
                prenom VARCHAR(30),
                dnaiss VARCHAR(6) NOT NULL DEFAULT '31/02',
                items TEXT,
                PRIMARY KEY (conserve_id),
                UNIQUE UC_conserve_id (conserve_id));");
}


function stocker_immediatement($eleve_id,$items){//appele par "verifier_stocker" et associer_conserve
//print_r($items);                               //==============================
$tabitems=explode("#",$items);                   //$items="item1,date1#item2,date2,..."
$nbitems=0;
foreach($tabitems as $ligneitem) {
    list($item_id,$_date)=explode(",",$ligneitem);// format : '4,1990-02-15 12:12:03'
    $res=query("SELECT resultat_id FROM resultats 
                WHERE eleve_id=".seci($eleve_id )." and item_id=".seci($item_id));
    if (mysql_num_rows($res)==0) {                
		//eleve_id n'a pas dj item_id
		//ATTENTION POUR MELIA !!! Ici, disc_id=-1 !!!
    	if (query("INSERT INTO resultats SET disc_id=-1, eleve_id=".seci($eleve_id)." , item_id=".seci($item_id)." , quand='$_date'"))
           $nbitems++;
           
        }
	}
return $nbitems;
}

//====================
//ajoute les items de resultats.resultat_id  ceux de eleves.eleve_id
//====================
function associer_conserve($conserve_id,$eleve_id) {  // passage 5 : on tient le bougre  itemiser
global $table;                                        //==========================================
$res=query("SELECT items FROM $table WHERE conserve_id='$conserve_id';");
list($items)=mysql_fetch_array($res);
stocker_immediatement($eleve_id,$items);
query("DELETE FROM $table WHERE conserve_id='$conserve_id';");
$PHP_SELF=basename($_SERVER['PHP_SELF']);
goto($PHP_SELF."?op=lister_conserves");
queue();
}

//====================
//affiche un lve import et propose des homonymes de la base actuelle
//l'admin en slectionne un qui sera (au niveau de passage suivant) envoy 
//la fonction associer_conserve($conserve_id,$eleve_id)
//====================
function traiter_conserve($conserve_id) {             // passage 4 : un lve est dtermin par l'admin
                                                      //===============================================
global $table,$etab_id,$sess_ascol;
$PHP_SELF=basename($_SERVER['PHP_SELF']);
entete();
$res=query("SELECT * FROM $table WHERE conserve_id='$conserve_id';");
list(,$nomquot,$prenomquot,$dnaiss,$items)=mysql_fetch_array($res);

//rechercher les homonymes en tant le plus restrictif possible
$res=query("SELECT eleve_id, nom, prenom, dnaiss FROM eleves
            WHERE nom='$nomquot' and prenom='$prenomquot' and dnaiss='$dnaiss'
              and etab_id=$etab_id
              and annee=$sess_ascol;");
if (mysql_num_rows($res)==0) { //recherche trop restrictive ?
    $res=query("SELECT eleve_id, nom, prenom, dnaiss FROM eleves
                WHERE nom='$nomquot' and (prenom='$prenomquot' or dnaiss='$dnaiss')
                  and etab_id=$etab_id
                  and annee=$sess_ascol;");
    if (mysql_num_rows($res)==0)  { //recherche encore trop restrictive ?
        $res=query("SELECT eleve_id, nom, prenom, dnaiss FROM eleves
                     WHERE nom='$nomquot'
                       and etab_id=$etab_id
                       and annee=$sess_ascol;");
    }
}
$nom=stripslashes($nomquot);$prenom=stripslashes($prenomquot);
print "<p>Choisissez l'lve correspondant  $nom $prenom, $dnaiss<br />";
print "(ou slectionnez le bouton radio de la dernire ligne) :</p>";
print "<form method=\"post\" action=\"$PHP_SELF?op=associer_conserve\">";
print "<table border=\"1\">\n";
print "<tr class='rubrique'><td>Slectionn</td><td>Nom</td><td>Prnom</td><td>Date de naissance</td></tr>\n";
$first=true;
while (list($eleve_id,$nom,$prenom,$dnaiss)=mysql_fetch_array($res)) {
    if ($first) { $checked="checked"; $first=false; }
    else $checked="";
    print "<tr><td  align=\"center\">\n";
    print "<input type=\"radio\" name=\"eleve_id\" value=\"$eleve_id\" $checked ></td>\n";
    print "<td>$nom</td><td>$prenom</td><td align=\"center\">$dnaiss</td>\n";
    print "</tr>\n";
}
print "<tr><td align=\"center\"><input type=\"radio\" name=\"eleve_id\" value=\"0\"></td>\n";
print "<td colspan=\"3\">Il n'est pas dans cette liste (donc \"oublier\" cet lve).</td>\n";
print "</table><p>\n";
print "<input type=\"hidden\" name=\"conserve_id\" value=\"$conserve_id\">\n";
print "<input type=\"submit\" class=\"coul\" name=\"choixde1\" value=\"Traiter le choix\">\n";
print "</p></form>\n";
queue();
}


//====================
//affiche les lves conservs pour ambigut ; l'admin en choisit un
//qui sera envoy  traiter_conserve($conserve_id)
//====================
function lister_conserves() {                         //passage de niveau 3
                                                      //===================
global $table;
$PHP_SELF=basename($_SERVER['PHP_SELF']);
entete();
$res=query("SELECT * FROM $table;");
if (mysql_num_rows($res)==0) {
    print "Tous les lves imports ont t traits.";
    query("DROP TABLE $table");
}
else {
    print "<p>Voici les lves imports qui restent  traiter pour des raisons d'ambigut :</p>";
    print "<div align='center'><table  border=\"1\" >\n";
    print "<tr class='rubrique'>";
    print "<td>Nom</td><td>Prnom</td><td>Date de naissance</td></tr>\n";
    while (list($conserve_id,$nomquot,$prenomquot,$dnaiss,$items)=mysql_fetch_array($res)) {
          $nom=stripslashes($nomquot);$prenom=stripslashes($prenomquot);
          print "<tr><td><a href='$PHP_SELF?op=traiter_conserve&conserve_id=$conserve_id'>$nom</a></td>";
          print "<td>$prenom</td><td>$dnaiss</td></tr>";
    }
    print "</table></div>";
}
queue();
}

//====================
//enregistre un lve import qui a t trouv sans ambigut dans la base
//et met les autres en conserve
//propose en bas un lien pour s'occuper de l'ensemble des lves en conserve
//(c'est  dire pour obtenir la liste avec des liens)
//====================
function verifier_stocker($eleve,$items,&$traites,&$pastrouves,&$conserves) {  //appele par analyse_fichier
//===========================
//On vrifie l'galit forte (3 caractristiques identiques)
//puis l'galit probable (nom et (prenom ou dnaiss))
//puis l'galit possible (nom ou (prenom et naiss))
//d'autres choix sont possibles !
global $table,$etab_id,$sess_ascol;
list($nom,$prenom,$dnaiss)=explode(",",$eleve);
$nomquot=addslashes($nom);$prenomquot=addslashes($prenom);
$dnaiss=normerdatenaiss($dnaiss);
$res=query("SELECT eleve_id, nom, prenom, dnaiss FROM eleves
            WHERE nom='$nomquot' and prenom='$prenomquot'
              and dnaiss='$dnaiss'
              and etab_id=$etab_id
              and annee=$sess_ascol");
$nbhomo=mysql_num_rows($res);
if ($nbhomo==0) { //recherche trop restrictive ?
    $res=query("SELECT eleve_id, nom, prenom, dnaiss FROM eleves
                WHERE nom='$nomquot'
                  and (prenom='$prenomquot' or dnaiss='$dnaiss')
                  and etab_id=$etab_id
                  and annee=$sess_ascol;");
    $nbhomo=mysql_num_rows($res);
    if ($nbhomo==0) {
        $res=query("SELECT eleve_id, nom, prenom, dnaiss FROM eleves
                    WHERE nom='$nomquot'
                      and etab_id=$etab_id
                      and annee=$sess_ascol;");
        $nbhomo=mysql_num_rows($res);
    }
    if ($nbhomo==1) $nbhomo=-1; //la comparaison est insuffisante : on donnera le choix
}


print "<td>$nom $prenom ($dnaiss)</td>\n<td>&nbsp;";
switch ($nbhomo) {
    case 0 : print "n'a pas t trouv.";
             $pastrouves++;
             break;
    case 1 : list($eleve_id,,,)=mysql_fetch_array($res);
             $nb=stocker_immediatement($eleve_id,$items);
             switch ($nb) {
                 case 0 : $nbitems=count(explode("#",$items));
                          if ($nbitems>1) $pluriel="s"; else $pluriel="";
                          printf ("item%1\$s import%1\$s dj prsent%1\$s dans la base",$pluriel);
                          break;
                 case 1 : print "stockage d'un item";break;
                 default: print "stockage de $nb items";break;
             }
             $traites++;
             break;
    default: $res=query("SELECT * FROM $table WHERE nom='$nomquot' and prenom='$prenomquot' and dnaiss='$dnaiss';");
             if (mysql_num_rows($res)==0) { //l'lve import ne l'a pas dj t
                 print "requete : INSERT INTO $table SET nom='$nomquot', prenom='$prenomquot', dnaiss='$dnaiss', items='$items';<br>";
                 query("INSERT INTO $table
                        SET nom='".secs($nom)."', prenom='".secs($prenom)."', dnaiss='".secs($dnaiss)."', items='$items';");
                 print "cas ambigu qui sera tudi dans la phase suivante.";
             }
             else print "dj prsent dans la liste des cas ambigus.";
             $conserves++;
}
print "</td>";
}


//rassembler les lignes du fichier.
//chaque lve est envoy avec ses items  la fonction verifier_stocker
function analyse_fichier($fic) {                      //appele par "sauve"
global $table;
$attention=false;
$fp=fopen($fic,"r");
//chercher la somme de contrle (on ne se proccupe pas trop de la syntaxe ici
$total='';
while(!feof($fp)) {
    $line=trim(fgets($fp,LIM)); //nom, prenom, dnaiss
    switch ($line) {
        case "=" : $attention=true; break;
        case "i" : break;
        case "+" : break;
        case ""  : break;
        default  : if (!$attention) $total.=$line;
                   else $code=$line;
    }
}
if (empty($code))
    print "<p>Syntaxe du fichier incorrecte (= non trouv).</p>";
elseif (md5($total)!=$code)
	print "<p>Somme de contrle du fichier incorrecte !</p>";
else { //correct : engranger
    if (!creer_table()) {fclose($fp); die("Cration de la table $table impossible");}
    rewind($fp);
    $etab=trim(fgets($fp,LIM));
    fgets($fp,LIM); //ligne vide
    $car=trim(fgets($fp,LIM));
    $traites=$pastrouves=$conserves=0;
    print "<table border=\"1\">\n";
    print "<tr class='rubrique'><td align=\"center\">Elves</td>";
    print "<td align=\"center\">Dcision</td>";
    while(!feof($fp) && $car=="+") {
          $eleve=trim(fgets($fp,LIM)); //nom, prenom, dnaiss
          $items="";
          $car=trim(fgets($fp,LIM));
          while (!feof($fp) && $car=="i")  { //items
                 $items.=trim(fgets($fp,LIM))."#";           //avec sparateur #
                 $car=trim(fgets($fp,LIM));
          }
          //print "::$items::<br>";
          if ($items) $items=substr($items,0,-1);
          print "<tr>\n";
          verifier_stocker($eleve,$items,$traites,$pastrouves,$conserves);
          print "</tr>\n";
    }
    print "</table>\n";
    print "<br />";
    print "<table  border=\"0\">\n";
    printligne("Elves traits",$traites);
    printligne("Elves conservs en attente",$conserves);
    printligne("Elves non trouvs",$pastrouves);
    print "</table>\n";
    if ($conserves) {
	  $PHP_SELF=basename($_SERVER['PHP_SELF']);
        print "<p><a href=\"$PHP_SELF?op=lister_conserves\">";
        print "Traiter les lves en attente</a></p>\n";
    }
}
fclose($fp);
}

//le fichier est connu et envoy  la fonction "integration"
//====================
function sauve($infos) {                              //passage 2 : fichier connu
entete();                                             //=========================
$nomfic=$infos["name"];
$nomtemp=$infos["tmp_name"];
$tailletemp=$infos["size"];
if (empty($nomfic) || $nomfic=="none")
    print "<p>Erreur ! Vous n'avez pas indiqu de nom de fichier</p>";
elseif ($nomfic=="none")
    print "Erreur de copie du fichier $nomfic ou fichier dpassant 500 Ko<br>";
else
    analyse_fichier($nomtemp);
queue();
}

//premier affichage et saisie du nom du fichier d'import
//====================
function formulaire() {                               //passage 1
entete();                                             //=========
$PHP_SELF=basename($_SERVER['PHP_SELF']);
print "<hr><div align='center'><table width=80%  border=0><tr><td align=center><p >Slectionnez le fichier  importer :</p>";
print "<form name=\"form1\" method=\"post\" ENCTYPE=\"multipart/form-data\"
        action=\"$PHP_SELF?op=sauve\">";
print "<input type=\"hidden\" name=\"MAX_FILE_SIZE\" value=\"500000\">";
print "Fichier : ";
print "<input type=\"file\" name=\"monfic\" value=\"cliqu\"><br/><br/>";
print "<input type=\"submit\" class=\"coul\" name=\"envoific\" value=\"Envoyer au serveur\">";
print "</form> </td></tr></table></div>";
//print "<p style=\"font-family:Arial; font-style:italic; font-size:small; color:navy;\">\n";
//print "Vous pouvez indiquer plusieurs fichiers</p>";
queue();
}


////////// Programme principal /////////////



$table=$etab_id.'_conserves'; //table des conservs avant intgration

connecte($host,$user,$mdp,$db);
switch (@$op) {
    case "sauve" :
        //print_r($_POST);
        //print_r($_FILES);
         // passage 2 aprs avoir envoy le fichier
         $envoific=$_POST["envoific"];
         if (isset($envoific))
             sauve($_FILES["monfic"]);
         break;
    case "lister_conserves" :
         // passage 3, tant qu'il reste des mis en conserves
         lister_conserves();
         break;
    case "traiter_conserve" :
         // passage 4 : un lve est dtermin par l'admin
         traiter_conserve($conserve_id);
         break;
    case "associer_conserve" :
         //passage 5 : un import est associ  un lve
         associer_conserve($conserve_id,$eleve_id);
         break;
    default:
         //passage 1
         formulaire();
}
?>