<?php
   require_once "../lib/artichow/BarPlot.class.php";
  //Version de PHP :
  //$versionPHP=PHP_VERSION;
  //$versionPHP=substr($versionPHP,0,1);
  // On rcupre les valeurs  afficher sur le graphique dans $_GET['values'] et on les dsrialize

  $values = explode(',',$_GET['values']);
  $absc = explode(',',$_GET['absc']);	
  $niv=$_GET['niv'];
  $titre=stripslashes(urldecode($_GET['titre']));	
  $titreX=stripslashes(urldecode($_GET['titreX']));
  $titreY=stripslashes(urldecode($_GET['titreY']));

  $tabcoul=array(1=>'bleu',2=>'rouge',3=>'vert');
  $couleur=$tabcoul[$niv];
 
  // On fabrique les 3 couleurs pour les niveaux
  $bleu = new Color(85,160, 220); 
  $rouge= new Color(185,30, 30);  
  $vert=  new Color(30,160,85);
   
  if (count($absc)>16) $graph = new Graph(950, 400);
  else $graph = new Graph(800, 400);
  $graph->setAntiAliasing(TRUE);
  $graph->title->set($titre);
  $graph->title->setColor($$couleur);
  $graph->border->setStyle(LINE_DASHED);
  $graph->border->setColor(new DarkGray);
   
  //CrationHistogramme 
  $plot = new BarPlot($values,1,1,0);
  $plot->setBarColor($$couleur);
  $plot->setSpace(1, 1, NULL, NULL);
  $plot->setPadding(40, 25, 40, 40);
  
  //Etiquettes places au-dessus des barres
  $plot->label->set($values);
  $plot->label->move(0, -15);
  //Dgrad du fond des tiquettes
  $plot->label->setBackgroundGradient(
      new LinearGradient(
         new Color(250, 250, 250, 10),
         new Color(255, 255, 100, 30),
         0
      )
   );
  $plot->label->border->setColor(new Color(40, 100, 160, 20));
  $plot->label->setPadding(3, 1, 1, 0);
  
  //Lgende des axes
  $plot->yAxis->title->set($titreY);
  $plot->yAxis->title->setFont(new TuffyBold(10));
  $plot->yAxis->title->move(-4, 0);
  $plot->yAxis->setTitleAlignment(LABEL_TOP);

  $plot->xAxis->title->set($titreX);
  $plot->xAxis->title->setFont(new TuffyBold(10));
  $plot->xAxis->setTitleAlignment(LABEL_RIGHT);   

  $plot->setBackgroundColor(new Color(230, 230, 230));
  
  //  Graduation des abcisses
  $plot->xAxis->setLabelText($absc);
  $plot->xAxis->label->setFont(new TuffyBold(7));

  //Ombrage des barres  
  $plot->barShadow->setSize(5);
  $plot->barShadow->setPosition(SHADOW_RIGHT_TOP);
  $plot->barShadow->setColor(new Color(180, 180, 180, 10));
  $plot->barShadow->smooth(TRUE);

  //Trac  
  $graph->add($plot);
  $graph->draw();

?>
