<?php
#=
/****************************************************************************
Copyright 2002, Daniel Deycard, Jacques Messines, Alain Pomirol
(CATICE Acadmie de Bordeaux)

This file is part of Gibii.

Gibii is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Gibii is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Gibii; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/

include("../include/vars_adm.php");
include("../include/util.inc.php");
include("../include/get.inc.php");
include("../incorporation/individus.class.php");
include("../incorporation/importation.php");
include("../include/utiljs.php");
include("../include/html.class.php");
include("../incorporation/enluminures.inc.php");
require_once("../include/define.inc.php");


function morceau($ch,$quantite) {
$ret='';
$ch=strtoupper($ch);
for ($i=0; $i<max(strlen($ch),$quantite+1) ; $i++) {
	$car=$ch[$i];
	if ($car>='A' && $car<='Z') $ret.=$car;
	}
return $ret;
}


function result2csv(&$eleve) {
	//________________________________________________________________
	//A ADAPTER POUR MELIA !!! La discipline n'est pas prise en compte
	//""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
static $maxbrevet=0,$maxitem=0;
global $DATA,$etab_rne; 
if (!$maxbrevet) {
	list($maxitem,$maxbrevet)=
		mysql_fetch_array(
			query("SELECT max(item_id) as maxitem, max(brevet_no) as maxbrevet FROM items"));
	}
	
//$eleve est un objet eleve
$resb=query("SELECT niveau FROM brevets WHERE eleve_id=$eleve->id");
$tbrevets=array();
while (list($niveau)=mysql_fetch_array($resb)) {
	    $tbrevets[$niveau]=1;
      }
$tresultats=array();
$resr=query("SELECT item_id FROM resultats WHERE eleve_id=$eleve->id");
while (list($item_id)=mysql_fetch_array($resr)) {
    $tresultats[$item_id]=1;
    }
//stocker les dates des brevets
$listeb='';
for ($i=1 ; $i<=$maxbrevet ; $i++) {
	if (isset($tbrevets[$i])) $listeb.='1';
	$listeb.=';';
	}
//stocker les dates des items acquis
$listei='';
for ($i=1 ; $i<=$maxitem ; $i++) {
	if (isset($tresultats[$i])) $listei.='1';
	$listei.=';';
	}
$sauve=$eleve->nom.';'.$eleve->prenom.';'.$eleve->dnaiss.';'.$eleve->annee.';';
$sauve.=$listeb.' - ;'.$listei."\n";

//stocker dans un fichier local  l'tab
$nomfichier=$DATA.'/'.$etab_rne.'/elv_disparus.csv';
creertousrep($nomfichier);
$h=fopen($nomfichier,'ab'); //b pour Windows sinon, pas de passage  la ligne
fputs($h,$sauve);
fclose($h);
}

function purge($elvprof) {
global $etab_id, $sess_ascol, $etab_actif;
//les disparus (ncessairement d'une anne antrieure) ne sont pas supprims
//des tables profs et eleves ni de la table comptes mais ils sont inaccessibles
//par login (leur mot de passe a t remplac par n'importe quoi).
//ils ne seront pas lists dans d'autres scripts car ils ne vrifient plus
//les critres (anne essentiellement).

//purger les tables annexes (oblig de balayer les individus)
$ancien=new $elvprof();
$existe=$ancien->findfirst("etab_id=$etab_id and annee<$sess_ascol and tag=0");
if ($existe) {
	print "<h3>Anciens ".$elvprof."s :</h3>";
    $html=new htmlcreator();
    $html->begintable();
    $html->beginrow();
    $html->entetes("civil.","id","Nom","Prnom","dnaiss","anne","statut");
    $html->endrow();
    while ($existe) {
        print "<tr>\n";
        $ancien->couperficelles(); 
        if ($sess_ascol-$ancien->annee>=DELAI_PURGE_ELVPROF) {
    		if ($elvprof=='eleve') {
        		result2csv($ancien); 
				query("DELETE FROM brevets WHERE eleve_id=$ancien->id");
				suppr_resultats($ancien->id);
        		}
            else {
            	//l, on peut supprimer les rponses des profs disparus depuis
           	 	//plus de 4 ans : leurs rponses ont au moins le mme ge
               	query("DELETE FROM reponses WHERE prof_id=$ancien->id");
               	}
        	query("DELETE FROM $ancien->table WHERE $ancien->champ_id=$ancien->id");
        	query("DELETE FROM comptes WHERE compte_id=$ancien->compte_id");
        	$colstatut=" supprim ";
        	}
        else {
            //on ne supprime pas le compte mais on modifie le compte avec
            //un mdp introuvable
            query("UPDATE comptes SET mdp='d85e030463a0d51a0de102db412373c1'
                    WHERE compte_id=".seci($ancien->compte_id));
            $colstatut=" cach ";
            }
        $html->colonnes($ancien->civil,$ancien->id,$ancien->nom,
                        $ancien->prenom,$ancien->dnaiss,$ancien->annee,$colstatut);
        $html->endrow();
        $existe=$ancien->findnext();
        }
    $html->endtable();
    }

//revirgination de la table eleves ou profs
query("UPDATE $ancien->table SET tag=0
       WHERE etab_id=$etab_id and tag<>-1 and tag<>1;");
       //on laisse la famille TEST tranquille ainsi que les incertains non encore traits

//ractivation de l'tablissement
query("UPDATE etablissements SET actif=".seci($etab_actif )." WHERE etab_id=$etab_id");

//compte des individus restants
$res=query("SELECT * FROM $ancien->table
            WHERE tag=0 and etab_id=$etab_id and annee=$sess_ascol;");
if ($elvprof=='eleve') $article="d'"; else $article="de ";
print "<p>Nombre actuel $article$ancien->table dans l'tablissement pour l'anne scolaire $sess_ascol-".($sess_ascol+1)." : ".mysql_num_rows($res)."<br />";
$res=query("SELECT * FROM $ancien->table
            WHERE tag=0 and etab_id=$etab_id and annee<$sess_ascol;");
print "Nombre $article$ancien->table d'une anne scolaire antrieure (anciens) : ".mysql_num_rows($res)."</p>";

//s'occuper de la famille TEST : changement d'anne seulement
//Eleve et Prof TEST ne sont pas comptabiliss dans les individus ci-dessus
query("UPDATE $ancien->table SET annee=$sess_ascol WHERE tag=-1");

} //fonction purge

function nettoyerclasses() {
//on supprime les classes/groupes sans lves et sans profs
global $etab_id;
$resclasses=query("SELECT classe_id FROM classes WHERE etab_id=$etab_id;");
while (list($classe_id)=mysql_fetch_array($resclasses)) {
    //on tient compte des disparus dont on garde la classe
    $reselv=query("SELECT * FROM lien_eleves_classes WHERE classe_id=$classe_id LIMIT 1;");
    if (!mysql_num_rows($reselv)) {
        //cette classe n'a pas d'lve...
        //(ce qui peut tre normal si eleves.txt passe en dernier)
        $resprof=query("SELECT prof_id FROM lien_profs_classes
                        WHERE classe_id=$classe_id LIMIT 1;");
        if (!mysql_num_rows($resprof)) {
            //cette classe n'a pas de profs non plus
            query("DELETE FROM classes WHERE classe_id=$classe_id;");
            }
        }
    }
}

function nettoyerfich() {
global $etab_id,$HIDEDATA;
$etab_rne=getrne($etab_id);
$dest="$HIDEDATA/$etab_rne/individus/";
creertousrep($dest);
if ($handle=opendir($dest)) {
   while  ($fich=readdir($handle)) {
       $bout=explode(".",$fich);
       if ($bout) $ext=strtoupper($bout[count($bout)-1]);
       if ($fich !="." && $fich !=".." && ($ext=="DBF" || $ext=="TXT"))   {
          print "<br>Fichier supprim : ".$dest.$fich;
          unlink($dest.$fich);
       }
   } //fin recherche fichiers
} //if
}


//==============================================================================
opensession("Admin",false);
connecte($host,$user,$mdp,$db);
set_time_limit(0);

entete("Importation : phase de nettoyage des tables");
if ($incoreleves) purge('eleve');
if ($incorprofs)  purge('prof');
nettoyerclasses(); //supprime les classes sans lve
if ($purgefic==1) nettoyerfich(); //supprime tous les fichiers du rp priv
print "<p><b>L'incorporation est termine.</b></p>";

unset($_SESSION['incoreleves'],$_SESSION['incorprofs']);

print "<span style=\"font-family:sans-serif;font-size:12pt;font-style:italic;font-weight:bold;\">";
print "\n<a name=\"bas\"></a>\n";

if ($MODULE=="Melia") {
     print "<a href=\"../outils/choixlangues.php?retour=".
               urlencode("../admin/admin_bas.php")."\">
               Choix des langues de l'tablissement
               </a>";
     }
else {
     print "<a href=\"../admin/admin_bas.php\">
               Retour au menu admin
               </a>";
     }
print "</span>\n";
enqueue();
?>