<?php
#G
#=
/****************************************************************************
Copyright 2002, Daniel Deycard, Jacques Messines, Alain Pomirol
(CATICE Acadmie de Bordeaux)

This file is part of Gibii.

Gibii is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Gibii is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Gibii; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/

include_once('../include/get.inc.php');

function creer_table_divers() {
$sql="CREATE TABLE IF NOT EXISTS divers (
		divers_id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY ,
		motcle VARCHAR( 50 ) NULL ,
		id INT NULL ,
		etab_id INT NULL,
		vrac BLOB NULL ,
		INDEX ( motcle , id )
		) ";
$v=mysql_get_server_info();
if ($v[0]=='5') $sql.=" ENGINE = MYISAM ";
query($sql);
}


function garderVrac(&$nouveau) {
global $modele,$champactif,
	   $logfournis,$mdpfournis,$razmdp,$logprioanc,$mdpenclair;
$nouveau->vrac=array();
foreach(array('modele','champactif','logfournis','mdpfournis','razmdp','logprioanc','mdpenclair') as $idx) {
	$nouveau->vrac[$idx]= $$idx;
	}
$blob=addslashes(serialize($nouveau));
creer_table_divers();
query("INSERT INTO divers SET motcle='$nouveau->table', id=$nouveau->id, etab_id=$nouveau->etab_id, vrac='$blob'");
return mysql_insert_id();
}		

function garderIncertain(&$nouveau) {
global $modele,$champactif,
	   $logfournis,$mdpfournis,$razmdp,$logprioanc,$mdpenclair;
$nouveau->ajoutertable(1);   //ajoute avec tag=1; affecte $this->id
return garderVrac($nouveau);
}


function loginPourNouveau(&$nouveau) {
global $logfournis, $logprioanc, $modele;
if ($logfournis && !empty($nouveau->login)) {
	$txtlog=$nouveau->login; //car modifi par creerL...
	$newlog=$nouveau->creerloginunique($modele); //$nouveau->login est aussi affect
    if ($logprioanc) {
        //on cherche  crer le login fourni et on garde le rsultat, mme s'il est suffix
		if ($txtlog==$newlog) $nouveau->addmess("- le login du fichier texte ($txtlog) a t attribu");
		else $nouveau->addmess("- le login fourni a d tre suffix ($newlog au lieu de $txtlog)");
		}
    elseif ($newlog!=$txtlog) {
        //il existe un user dont il faut modifier le login
    	query("UPDATE comptes SET login='".secs($newlog)."'
    			WHERE login='".secs($txtlog)."' AND etab_id=$nouveau->etab_id");
        $nouveau->addmess("- <span class=\"warning\"><b>Attention</b></span>
        					Le login d'un ancien utilisateur a d tre modifi ; son nouveau est $newlog");
        $nouveau->login=$txtlog;
        $nouveau->addmess("- login de l'utilisateur courant : $txtlog");
    	}
    else {
        $nouveau->addmess("- login : celui du fichier texte ($txtlog)");
        }
    }
else {
    $nouveau->creerloginunique($modele);
    $nouveau->addmess("- login cr : $nouveau->login");
	}
}

function mdpPourNouveau(&$nouveau) {
global $mdpfournis,$mdpenclair;
if ($mdpfournis) {
    if ($mdpenclair) {
        $nouveau->mdp=md5($nouveau->mdp);
        $nouveau->addmess("- mdp transform par MD5  partir du fichier texte");
        }
    else $nouveau->addmess("- mdp fourni tel quel depuis le fichier texte");
    }
else {
    $nouveau->mdp=md5($nouveau->dnaiss);
    $nouveau->addmess("- mdp crypt  partir de dnaiss");
    }
}

//----------------------------------------------------------
function majAncienMemeEtab(&$ancien,&$nouveau) {
global $modele,$champactif,$etab_id,
	   $logfournis,$mdpfournis,$razmdp,$logprioanc,$mdpenclair;
if ($logfournis && $nouveau->login) {
    if ($ancien->login!=$nouveau->login) {
        //l'ancien a xy, le nouveau a zt
        $txtlog=$nouveau->login;
        $newlog=$nouveau->creerloginunique($modele); //$nouveau->login est affect dans la fonction
        $nouveau->addmess("txt login=$txtlog - nouveau login=$newlog - ancien login=$ancien->login");
        //si on trouve zt, c'est bon pour zt dans tous les cas
        if ($newlog!=$txtlog) {
            if ($logprioanc) {
            	//un user DOIT changer de login
                query("UPDATE comptes SET login='".secs($newlog)."'
                        WHERE login='".secs($txtlog)."' AND etab_id=$nouveau->etab_id");
                $nouveau->login=$txtlog;
                $nouveau->addmess("- <span class=\"warning\"><b>Attention</b></span>
                                    Le login $txtlog d'un ancien utilisateur a d tre modifi
                                    et son nouveau login est maintenant $newlog");
                $nouveau->addmess("- le login de l'utilisateur courant ($nouveau->nom, $nouveau->prenom, $nouveau->dnaiss)
                					est bien maintenant $txtlog");
                }
            else $nouveau->addmess("- le login attribu est $newlog car le login demand ($txtlog) existait dj");
            }
        else $nouveau->addmess("- l'ancien login ($ancien->login) a t remplac par celui du fichier texte ($txtlog)");
        $loginquot=addslashes($nouveau->login);
        $set[]="login='$loginquot' ";
        }
    else $nouveau->addmess("- l'ancien login ($ancien->login) a t conserv (identique  celui du fichier texte)");
    }
else {
	//les logins ne sont pas fournis dans le fichier texte (ou l'admin s'est plant de bouton)
	$nouveau->login=$ancien->login;
	$nouveau->addmess("- l'ancien login a t conserv");
	}
if ($nouveau->login!=$ancien->login)
	$nouveau->addmess("<span class=\"attention\">- le login a t modifi.</span>");
}

//----------------------------------------------------------
function majAncienChangementEtab(&$ancien,&$nouveau) {
global $modele,$champactif,$etab_id,
	   $logfournis,$mdpfournis,$razmdp,$logprioanc,$mdpenclair;
if ($logfournis && $nouveau->login) {
    $txtlog=$nouveau->login;
	//tester si le login fourni dans le fichier texte n'est pas dj utilis (creerloginunique en retournera un autre)
    $newlog=$nouveau->creerloginunique($modele); //$nouveau->login est affect dans la fonction
    $nouveau->addmess("txt login=$txtlog - nouveau login=$newlog - ancien login=$ancien->login");
    if ($newlog!=$txtlog) {
        if ($logprioanc) {
        	//un user DOIT changer de login
            query("UPDATE comptes SET login='".secs($newlog)."' WHERE login='".secs($txtlog)."' AND etab_id=$nouveau->etab_id");
            $nouveau->login=$txtlog;
            $nouveau->addmess("- <span class=\"warning\"><b>Attention</b></span>
                                Le login $txtlog d'un ancien utilisateur a d tre modifi
                                et son nouveau login est maintenant $newlog");
            $nouveau->addmess("- le login de l'utilisateur courant ($nouveau->nom, $nouveau->prenom, $nouveau->dnaiss)
            					est bien maintenant $txtlog comme prvu par les options choisies");
            }
        else $nouveau->addmess("- le login attribu est $newlog car le login demand ($txtlog) existait dj");
        }

    else $nouveau->addmess("- le login du fichier texte $txtlog convient dans l'tablissement");
    }
else {
	//les logins ne sont pas fournis dans le fichier texte mais il y a eu changement d'tablissement
	//tester si le login fourni dans le fichier texte n'est pas dj utilis (creerloginunique en retournera un autre)
	$nouveau->login=$ancien->login; //a priori
    $newlog=$nouveau->creerloginunique($modele); //$nouveau->login est affect dans la fonction
	if ($nouveau->login==$ancien->login)
		$nouveau->addmess("- le login de l'ancien tablissement a t conserv");
	else 
		$nouveau->addmess("<span class=\"attention\">- le login de l'ancien tablissement ($ancien->login) 
							 a t d tre modifi ($nouveau->login) pour viter un conflit.</span>");
	}
}

function majMotDePasse(&$ancien,&$nouveau) {
global $modele,$champactif,$etab_id,
	   $logfournis,$mdpfournis,$razmdp,$logprioanc,$mdpenclair;

if ($mdpfournis) {
    if ($mdpenclair) {
        $nouveau->mdp=md5($nouveau->mdp);
        $nouveau->addmess("- mdp transform par MD5  partir du fichier texte");
        }
    else $nouveau->addmess("- mdp fourni crit tel quel dans la base (il est dj crypt dans le fichier texte");
    }
else {
    if ($razmdp) {        
    	  //demande de rinitialisation
        $nouveau->mdp=md5($nouveau->dnaiss);
		    $nouveau->addmess("- mdp rinitialis (cryptage de la dnaiss)");
        }
    else {
    	  $nouveau->mdp=$ancien->mdp;
        }
    }

if ($nouveau->mdp!=$ancien->mdp) 
    $nouveau->addmess("<span class=\"attention\">- le mot de passe a t modifi.</span>");
else $nouveau->addmess("- le mot de passe est le mme que l'ancien");
}
	

//==========================================================	
function majancien(&$ancien,&$nouveau) {
global $modele,$champactif,$etab_id,
	   $logfournis,$mdpfournis,$razmdp,$logprioanc,$mdpenclair;

$nouveau->updatetable($ancien);      //met  jour eleves ou profs et l'id de nouveau
$nouveau->updateoptions();          //langues (lve) ou classes (prof)
$nouveau->updategroupe_en_lien($ancien);
$set=array();
if ($nouveau->etab_id==$ancien->etab_id) 
	majAncienMemeEtab($ancien,$nouveau);
else 
	majAncienChangementEtab($ancien,$nouveau);
majMotDePasse($ancien,$nouveau);

//mettre ventuellement la table comptes  jour
//---------------------------------------------
$set=array();
if ($nouveau->login!=$ancien->login) {
	$set[]=" login='".addslashes($nouveau->login)."' ";
	}
if ($nouveau->mdp!=$ancien->mdp) {
    $set[]=" mdp='$nouveau->mdp' ";
	}
if ($nouveau->etab_id!=$ancien->etab_id) {
    $set[]=" etab_id=$nouveau->etab_id ";
    }
if (count($set)) {
	$chset=implode(', ',$set);
	$nouveau->addmess("- table `comptes` modifie");
    query("UPDATE comptes SET $chset WHERE $ancien->champ_id=$ancien->id"); 
    }
}


//==========================================================
function maj_ancien_nouveau(&$ancien,&$nouveau) {
global $champactif,$modele,$etab_id,$sess_ascol,
	   $logfournis,$mdpfournis,$razmdp,$logprioanc,$mdpenclair;

$res=query("SELECT login,mdp FROM comptes WHERE compte_id=$ancien->compte_id;");
if (empty($ancien->compte_id) || $ancien->compte_id==NULL || $ancien->compte_id==0 || mysql_num_rows($res)==0)  {
    //cas exceptionnel : pas d'enregistrement dans la table compte
    $nouveau->updatetable($ancien);      //met  jour eleves ou profs et l'id de nouveau
	$nouveau->updategroupe_en_lien($ancien);
    $nouveau->updateoptions();              //langues (lve) ou classes (prof)
    $nouveau->addmess("- existait dans la table $nouveau->table mais sans compte");
    $nouveau->addmess("- un nouveau compte a t cr, avec login=$nouveau->login");
    loginPourNouveau($nouveau);
    mdpPourNouveau($nouveau);
    $nouveau->insertcompte($champactif);
    return;
    }

list($ancien->login,$ancien->mdp)=mysql_fetch_array($res);
$metab=$ancien->etab_id==$etab_id;          //champs non vides
$mannee=$ancien->annee==$sess_ascol;        //champs non vides

if ($mannee &&  $metab)  {           //repasse ------------------------------------------------------------
    $nouveau->addmess("- dj prsent dans la base (mme anne et mme tab) ; mis  jour");
    majancien($ancien,$nouveau);
    return ;
    }

if (!$mannee &&  $metab)  {          //ancien du mme tab-------------------------------------------------
    $nouveau->addmess("- ancien du mme tablissement");
    majancien($ancien,$nouveau);
    return ;
    }

$oldetab=getetab($ancien->etab_id);
$oldetabaff=$oldetab['nom'].' - '.$oldetab['ville'];

if (!$mannee && !$metab)  {          //ancien d'un tab diffrent OU  cheval sur 2 -----------------------
    //si c'est un cas " cheval" l'autre tab n'a pas fait la bascule donc
    //il tombera dans le cas ($mannee && !$metab) ci-dessous et il crera un clone
    $nouveau->addmess("- ancien d'un autre tablissement ($oldetabaff)");
    majancien($ancien,$nouveau);
    return ;
    }

//ici on a ($mannee && !$metab)      //chgt tab en cours d'anne OU  cheval sur 2 -----------------------
if ($ancien->statut=='Eleve') {         //un lve ne peut pas tre  cheval
    $nouveau->addmess("- changement d'tablissement en cours d'anne (vient de $oldetabaff)");
    majancien($ancien,$nouveau);
    return ;
    }
else {                               //type n3/3 d'incertain  -------------------------------------------------
    $nouveau->addmess("- prof ayant chang d'tab en cours d'anne (ancien = $oldetabaff) ou  cheval sur 2 tabs (il faudra crer un clone)");
    $nouveau->addmess('- Cas ambigu :  dterminer ultrieurement (traitement des incertains).','red');
	garderIncertain($nouveau);
    //Le compte n'est pas cr
    return ;
    }
}


function engranger(&$nouveau) {
global $champactif,$modele,
	    $logfournis,$mdpfournis,$razmdp,$logprioanc,$mdpenclair,
		$etab_id,$sess_ascol,$MODULE,$etab_niveau;
//recherche les homonymes "bruts" dans la table d'origine (noms, prnoms identiques)
$result=$nouveau->qhomo();
if (is_object($result)) {
	$nbhomo=1;
	$ancien=$result;
	$certain=true;
	}
else {
	$nbhomo=$result;
	$ancien=NULL;
	$certain=false;
	}
$nouveau->addmess("nombre d'homonymes : $nbhomo");
$trouve=0;
switch ($nbhomo) {
	case 0 :
        $nouveau->addmess("- nouveau");
        $nouveau->ajoutertable(0);  //tag=0 : vrai nouveau
		$nouveau->ajoutgroupe_en_lien(); 
        loginPourNouveau($nouveau);
        mdpPourNouveau($nouveau);
        $nouveau->insertcompte($champactif);
        if ('Melia'==$MODULE || 'prof_id'==$nouveau->champ_id)
            $nouveau->ajouteroptions(0); //sinon, la table restera vide (lien_eleves_disciplines) sous GiBii
        if ('Melia'==$MODULE && 'prof_id'==$nouveau->champ_id)
            $nouveau->cochercompetences($etab_niveau);
        $trouve=1;
    	break;
	case 1 :
        if ($certain) {            
        	if ($ancien->etab_id==$etab_id) {
        		$etabaff='(le mme)';
        		}
            else {
                $etab=getetab($ancien->etab_id);
                $etabaff=$etab['nom'].' - '.$etab['ville'];
                }
        	$mess="<font color=\"navy\"><strong>$ancien->nom, $ancien->prenom, $ancien->civil, $ancien->dnaiss, anne=$ancien->annee, tab=$etabaff";
            if (!empty($ancien->ident_nat)) $mess.=", $ancien->ident_nat ";
            $mess.="</strong></font>";
            $nouveau->addmess($mess);
            if (!empty($nouveau->ident_nat) && $nouveau->ident_nat==$ancien->ident_nat) 
				$nouveau->addmess('- mmes ident_nat');
			if (!empty($nouveau->uid) && $nouveau->uid==$ancien->uid) 
				$nouveau->addmess("- galit des identificateurs nationaux (INE pour l'lve)");
			
            maj_ancien_nouveau($ancien,$nouveau); //true sauf cas particulier rare
            $trouve=1;
            }
		else {  //type n1/3 d'incertain
			$nouveau->addmess("- cas ambigu (un homonyme  dterminer ultrieurement (traitement des incertains).",'red');
			garderIncertain($nouveau);
            }
      	break;
	default : // type n2/3 d'incertain
        $nouveau->addmess("- cas ambigu : trop d'homonymes. A dterminer ultrieurement (traitement des incertains).",'red');
		garderIncertain($nouveau);
	}
unset($ancien);
$nouveau->findclose();
return $trouve; //0 ou 1
}


//----------------------------
function afficher(&$nouveau,$tout=true) {
global $MODULE;
print "<h2>";
print "$nouveau->nom, $nouveau->prenom, $nouveau->civil, $nouveau->dnaiss, $nouveau->uid, ";
if ($nouveau->statut=='Prof') {
        print "$nouveau->discipline";
        $listecl='';
        foreach($nouveau->classes as $classe_id) $listecl.= "'".getclasse($classe_id)."' ";
        if ($listecl) print ", classes=[ $listecl]";
    }
else {
        print "$nouveau->divcod";
        if ($MODULE=='Melia') {
           print ", langues=[ ";
           foreach($nouveau->lv as $ind=>$langue_id) print " LV$ind:".getlangue($langue_id)." ";
           print "]";
           }
}
if ($tout) {							//affichage dtaill
	print "</h2>\n";
	$espaces=str_repeat("&nbsp;",10);
	for ($i=0; $i<count($nouveau->messages);$i++) {
	        $mess=$nouveau->messages[$i];
	        echo $espaces,$mess,'<br />';
		}
	}
else print ", $nouveau->login</h2>\n"; //affichage restreint pour la rsolution d'un incertain
}


//----------------------------
function affichererreur($chligne,$nouveau,$batch) {
if ($batch) {
	logf($chligne."\n");
	logf("  ".$nouveau->messages[0]."\n");
	}
else {
	print "<h3><font color=\"orange\">$chligne</font></h3>";
	print "<p>";
	print "<font color=\"orange\">".$nouveau->messages[0]."</font>";
	print "</p>\n";
	print "<p>";print_r($nouveau->messages);print "</p>";
	}
}


//utilise dans txt2tables et dans batch_incorporation
//----------------------------------------
function get_errmsg($errcode) {
$msg="";
switch ($errcode) {
	case -1 : $msg= "Pas de sparateur trouv";break;
	case -2 : $msg= "Un des libells de champ est absent";break;
	case -3 : $msg= "Un des champs doublonne";break;
	case -4 : $msg= "L'un des champs est inconnu";break;
	}
return $msg;
}

function getprotomap($elvprof,$fichier) {
global $etab_id,$sess_ascol;
$nouveau=new $elvprof();
$nouveau->etab_id=$etab_id;
$nouveau->annee=$sess_ascol;
$nouveau->maptxt($fichier); 	//affecte $nouveau->sep, $nouveau->entete et $nouveau->map
return $nouveau;
}


function balayer_txt($elvprof,$fichier,$batch=false,$verbose=true) {
//l'en-tte ventuel a t vrifi. On le recalcule afin de tomber sur les donnes,
//ce qui est certainement moins coteux que de le stocker en session  la fin de la vrification.
global $champactif,$sess_ascol,$etab_id,
	   $logfournis,$mdpfournis,$razlog,$razmdp,$logprioanc,$mdpenclair;
	   
$nouveau=getprotomap($elvprof,$fichier);
if ($nouveau->codemap<0) return array($nouveau->codemap,$nouveau->entete);
	
$sep=$nouveau->sep;
$fp = fopen($fichier, "r");

//chercher et sauter la ligne d'en-tte
if ($nouveau->codemap>0) { //il y a un en-tte (code=1)
	while($buffer=fgets($fp,1024)) {
		if (strpos($buffer,$sep)!==false) break; //on saute les 1res lignes sans en-tte
	    }
	//le pointeur de fichier est juste aprs la ligne d'en-tte
	}

unset($nouveau->exemples,$nouveau->entete); //on libre un peu de place...

$nbincertains=0;$nbtraites=0;
while ($ligne = fgetcsv ($fp, 1024,$sep)) {
	$chligne=implode($ligne," ");
	if (!trim($chligne)) continue;
	if ($chligne[0]=="#") continue;
	if ($nouveau->setbytxt($ligne,$mdpenclair))  { 
		//print "<br><br>aprs setbytxt : nouveau = ";print_r($nouveau);print "<br><br>";
		$nouveau->verbose=$verbose;         
		if (!engranger($nouveau)) $nbincertains++;
		$nbtraites++;
		if ($verbose) {
			afficher($nouveau);
			print "<br /><br />";         
			}
		}
	else affichererreur($chligne,$nouveau,$batch); //verbose ou pas on affiche les erreurs
	$nouveau->vider();// c'est le mme qui sert ; le nettoyer, sauf sa table, etab_id et annee
	}
return array($nbincertains,$nbtraites);
}
?>