<?php
#G
#=
/****************************************************************************
Copyright 2002, Daniel Deycard, Jacques Messines, Alain Pomirol
(CATICE Acadmie de Bordeaux)

This file is part of Gibii.

Gibii is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Gibii is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Gibii; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/

//=============================================================================
// Fonctions annexes utilises dans l'importation
//=============================================================================

include("../include/vars_adm.php");
include("../incorporation/util.class.php");
include("../include/utiljs.php");
include("../include/util.inc.php");
include("../include/get.inc.php");

//define ("CODEGROUPE",'');

function en_tete($fichier,$verbose) {
    print "<h2>Traitement du fichier $fichier</h2>\n";
}

function fintraitement($fichier) {
    print "<p><strong><font size=\"+1\"><em>
           Fin du traitement de ".strtoupper($fichier).
           "</em></font></strong></p><hr>\n";
}

function affcellule($cellule) {
    print "<td>$cellule</td>\n";
}

function e($message) {
global $chligne, $nblignes, $fichier;
//affiche une erreur pour une ligne du fichier texte
print "<font color=\"red\">Ligne <b>$nblignes</b> ($message) : </font>
       $chligne<br>";
}

function aff($mess,$couleur) {
print "<font color=\"$couleur\">";
print $mess;
print "</font>\n";
print "<br>\n";
}


//=============================================================================
// Fonctions d'importation du GEP
//=============================================================================
function wind($verbose,&$profs) {
global $etab_id,$fichierwind,
       $MDP_INIT_GEP;
$nomfichier="f_wind.dbf";
en_tete($nomfichier,$verbose);


if (!function_exists("dbase_open"))  {
    alert("PHP n'est pas configur pour grer les fichiers dBase.\nVrifiez sa configuration ou utilisez les fichiers textes ou utilisez EasyPHP avec l'extension dBase");
    exit();
}
//visite du fichiers f_wind.dbf
$dbgep=dbase_open($fichierwind,0);   //0=lecture
$numlignes=dbase_numrecords($dbgep);
//print "<br>Le fichier a $numlignes lignes<br>";
for ($ligne=1; $ligne<=$numlignes; $ligne++) {
     $record=dbase_get_record_with_names($dbgep,$ligne);
     //le "deleted" des tables DBF ne semble pas marcher donc palliatif...
     //essai de critre d'existence raliste
     if (strlen($record["INDNNI"])>2 and $record["FONCCO"]=="ENS") {

        //nom prnom
        //seul l'un des champ CIVILI (wind) et AICIVI (ind) n'est pas vide
        $civil=strtolower($record["CIVILI"]);
        if (empty($civil) || strlen($civil)<2 || $civil[0]!='m') $civil="m.";
        else {
             switch ($civil[1]) {
                 case ".": $civil="M.";break;
                 case "l": $civil="Mlle";break;
                 case "m": $civil="Mme";break;
                 default:  $civil="?";break;
             }
        }
        $nom=ASCII2ANSI(trim($record["AINOMU"]));
        $prenom=ucwords(strtolower(ASCII2ANSI(trim($record["AIPREN"]))));

        //discipline
        $discco=trim($record["DISCCO"]);
        if (empty($discco)) $discco="0030X"; //pas de discipline => EDUCATION
        $disc_id=getdiscid($discco);
        if ($disc_id===false) { //limin !
                aff("- (non conserv pour MELIA) : $civil, $nom, $prenom","gray");
                continue;
        }
        $discipline=getdisc($disc_id);

        //date de naissance
        $dnaiss=$record["AINADD"];            // date de naissance format dBase : YYYYMMDD
        $dnaiss=substr($dnaiss,6,2)."/".substr($dnaiss,4,2); //."/".substr($dnaiss,0,4);
        $gep_id=(int) trim($record["NUMIND"]);//numro GEP du prof (il y a un espace dans le fichier)

        //mot de passe (en version avec niveau lev de confidentialit)
        if ($MDP_INIT_GEP) {
            $mdp=md5(trim($record["INDNNI"])); //NUMEN
            //print "numen=".$record["INDNNI"]." - $mdp - ";
        }
        else $mdp=md5($dnaiss);

        //Ajouter le prof au tableau $profs
        $profs[$gep_id]['civil']=$civil;
        $profs[$gep_id]['nom']=$nom;
        $profs[$gep_id]['prenom']=$prenom;
        $profs[$gep_id]['disc_id']=$disc_id;
        $profs[$gep_id]['dnaiss']=$dnaiss;
        $profs[$gep_id]['mdp']=$mdp;
        $profs[$gep_id]['classes']='';

        if ($verbose) aff("($gep_id), $civil, $nom, $prenom, $dnaiss, $discipline","green");
     }
}
fintraitement($nomfichier);
dbase_close($dbgep);
}

//retrouve les divisions et les groupes du prof
function men($verbose,&$profs) {                      //men = modules d'enseignement
global $etab_id,$fichiermen;
$nomfichier="f_men.dbf";
en_tete($nomfichier,$verbose);
if ($verbose) print "En noir, les doublons du fichier F_MEN.DBF<br><br>";
//balayer la table F_MEN.DBF (les groupes ou classes sont uniques)
$dbgep=dbase_open($fichiermen,0);   //0=lecture
$numlignes=dbase_numrecords($dbgep);
for ($ligne=1; $ligne<=$numlignes; $ligne++) {
    $record=dbase_get_record_with_names($dbgep,$ligne);
    $gep_id=(int) $record["NUMIND"];
    //groupe ou division
    $elstco=trim((string) $record["ELSTCO"]);  //Dans le DBF, il peut y avoir un espace  la fin
    $elstty=$record["ELSTTY"];
    //ici on garde les groupes !
    if (empty($elstco)) continue; // || $elstty=="G") continue;
    if (!isset($profs[$gep_id])) continue;

    //on tient une division de nom elsto
    //rcuprer le prof connaissant le gep_id
    //stocker les classes si l'enregistrement est valide
    if (strpos($profs[$gep_id]['classes'],";$elstco")===false) {
        //cette classe est dj indique
        //ce cas se produit lorsqu'un prof enseigne plusieurs disciplines dans la mme classe
        if ($elstty=='G') $codegr=''; else $codegr='';
        $profs[$gep_id]['classes'].=";$codegr$elstco"; // la fin : ";4C;3B;basque_niv2;5D"
        $couleur="green";
    }
    else {
        $couleur="black";
    }
    if ($verbose)
        aff($profs[$gep_id]['nom'].', '.$profs[$gep_id]['prenom']." ~> $codegr$elstco",$couleur);
} //for
fintraitement($nomfichier);
dbase_close($dbgep);
} //men()

function professeurs($verbose) {
global $fichierwind,$fichiermen,
       $incorwind,$incormen,
       $etab_rne,$etab_id, $HIDEDATA;
$profs=array();
if ($incorwind) wind($verbose,$profs);
if ($incormen) men($verbose,$profs);
//le fichier texte va s'appeler '23_2003_02_12_profs.txt' (23=id_etab)
creertousrep("$HIDEDATA/$etab_rne/individus/");
$ftxt="$HIDEDATA/$etab_rne/individus/$etab_id".'_'.date("Y_m_d_").'profs.txt';
$fp=fopen($ftxt,'w');
//fputs($fp,"ident_nat;civil;nom;prenom;disc;dnaiss;login;mdp;classe1\n");
//              0       1    2     3    4     5      6    7     8
foreach($profs as $gep_id=>$prof) {
    //les classes commencent par un ";"
    //.
    $ligne=$gep_id.'_'.$etab_id.';'.$prof['civil'].';'.$prof['nom'].';'.$prof['prenom'].';'.$prof['disc_id'].
           ';'.$prof['dnaiss'].';;'.$prof['mdp'].$prof['classes'];
    fputs($fp,$ligne."\n");
    //print "($gep_id) ~> $ligne<br>";
}
fclose($fp);
return $ftxt;
}



function eleves($verbose) {
global $etab_id,$etab_rne,$fichierele,
       $MDP_INIT_GEP, $HIDEDATA, $MODULE;

//ouvrir la table des lves du GEP
if (!function_exists("dbase_open"))  {
    alert("PHP n'est pas configur pour grer les fichiers dBase.\nVrifiez sa configuration ou utilisez les fichiers textes ou utilisez EasyPHP avec l'extension dBase");
    exit();
}

//association des codages langues du GEP et de Melia
$langues=array("AGL"=>1, "ESP"=>2, "ALL"=>3, "ARA"=>7, "ITA"=>4, "POR"=>5, "RUS"=>6);

$fichier="f_ele.dbf";
en_tete($fichier,$verbose);

//rcuprer les classes dj ventuellement stockes
creertousrep("$HIDEDATA/$etab_rne/individus/");

//le fichier texte va s'appeler 'etab_23_2003_02_12_eleves.txt'
$ftxt="$HIDEDATA/$etab_rne/individus/$etab_id".'_'.date("Y_m_d_").'eleves.txt';
$fp=fopen($ftxt,'w');
//fputs($fp,"ident_nat;civil;nom;prenom;classe;dnaiss;login;mdp;lv1\n");
//            0         1    2     3      4      5     6    7   8   9   10
$dbgep=dbase_open($fichierele,0);   //0=lecture
$numlignes=dbase_numrecords($dbgep);
for ($ligne=1; $ligne<=$numlignes; $ligne++)  {
    $record=dbase_get_record_with_names($dbgep,$ligne);
    $classe=trim($record["DIVCOD"]);
    $nom=ASCII2ANSI(trim($record["ELENOM"]));
    $prenom=ucwords(strtolower(ASCII2ANSI(trim($record["ELEPRE"]))));
    //critre d'existence apparemment suffisant
    if (empty($classe) || empty($nom) || empty($prenom)) continue;

    $gep_id=trim($record["ELENOET"]);
    $sexe=$record["ELESEXE"];
    if ($sexe[0]=="F") $civil="Mlle";
    else $civil="M.";
    $dnaiss=$record["ELEDATNAIS"]; // date de naissance format dBase : YYYYMMDD
    $dnaiss=substr($dnaiss,6,2)."/".substr($dnaiss,4,2);//modif pour 3.3 ."/".substr($dnaiss,0,4);
    if ($MDP_INIT_GEP)
        $mdp=md5($record["ELENOPRO"]);  //NUMEN
    else $mdp=md5($dnaiss);

    //langues
    $lv=array(1=>'','',''); //les langues vivantes pratiques, dans l'ordre 1, 2, 3
    for ($i=1; $i<=12; $i++) {
        if (!isset($record["ELEOPT$i"])) continue; //ne va pas toujours jusqu' 12
        $opt=strtoupper(trim($record["ELEOPT$i"]));
        $lang=substr($opt,0,3);
        if (!isset($langues[$lang])) continue;
        $numlang=$langues[$lang];
        $numopt=substr($opt,3,1);
        if ($numopt<=3 && $numopt>=1) $lv[$numopt]=$numlang;
    }

    $couleur="green";
    if ($verbose) {
       $affichage="[$sexe] $nom $prenom, classe=$classe, dnaiss=$dnaiss";
       if ($MODULE=='Melia') $affichage.=", LV1=$lv[1], LV2=$lv[2],LV3=$lv[3]";
       aff($affichage,$couleur);
       }
    fputs($fp,$gep_id.'_'.$etab_id.";$civil;$nom;$prenom;$classe;$dnaiss;;$mdp;$lv[1];$lv[2];$lv[3]\n");
} //for
fintraitement($fichier);
dbase_close($dbgep);
fclose($fp);
return $ftxt;
}

////////////////
//prog principal
////////////////
// Les fichiers suivants doivent tre prsents dans rpertoire ./$rep
// avec des noms en minuscules (et $rep doit tre affect !)
// F_ELE.DBF (lves et leurs classes)
// F_WIND.DBF (profs et leurs discipline)
// F_MEN.DBF (profs et modules d'enseignements -divisions ou groupes)


opensession("Admin",false);
set_time_limit(0);
connecte($host,$user,$mdp,$db);


print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n";
print "<HTML><HEAD><meta http-equiv=\"content-type\" content=\"text/html; charset=ISO-8859-1\">\n<link rel=\"stylesheet\" href=\"../themes/".$etab_theme."/b2i.css\"></HEAD>";
print "<BODY class=\"arialadmin\">";

//les 6 variables ci-dessous sont en session
//mais il faut en affecter certaines "pour homogniser" !
if ($incorele==1)   {                                //var de session
    $fichiereleves=eleves(true);      //var de session
    $incoreleves=1;
    }
else {
    $incoreleves=0;
    $fichiereleves='';      //var de session
    }

if ($incorwind==1)  {
    $fichierprofs=professeurs(true); //var de session
    $incorprofs=1;                                //var de session
    }
else {
    $fichierprofs='';
    $incorprofs=0;
    }                                //var de session

session_puts('incoreleves');
session_puts('fichiereleves');
session_puts('incorprofs');
session_puts('fichierprofs');

print "<p><span style=\"font-family: sans-serif; font-size: 12pt;font-style: italic; font-weight: bold;\">\n";
print "<a href=\"../incorporation/txt2tables.php?op=#bas\">Traiter les fichiers textes crs</a> ...</span></p>";
print "<p>&nbsp;</p>";
print "<p>&nbsp;</p>";
print "<p>&nbsp;</p>";
print "<p>&nbsp;</p>";
print "<a name=\"fingep\"></a>";
print "</body></html>";

?>
