<?php
#D
/****************************************************************************

Copyright 2002, Daniel Deycard, Jacques Messines, Alain Pomirol
(CATICE Acadmie de Bordeaux)

This file is part of Gibii.

Gibii is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Gibii is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Gibii; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/

if (!isset($pdf_inc)) {
$pdf_inc=1;

function cree_pdf($fichier) {
 //cre juste jusqu' l'objet $pdf
 //Crer en mmoire ou en fichier ?
 if ($fichier=="0") {//Mode RAM : on cre une chane  afficher
  global $pophtm;
  $pophtm="<?php\n";
  $pophtm.="include(\"../../../include/vars_adm.php\");\n";
  $pophtm.="include(\"../../../include/util.inc.php\");\n";
  $pophtm.="include(\"../../../lib/fpdf.php\");\n";
  $pophtm.="\$pdf=new FPDF(\"P\",\"cm\",\"A4\"); \n";
  $pophtm.="\$pdf->Open();\n";
  $pophtm.="\$pdf->AddPage();\n";

 } else { //Mode fichier
 $fp=fopen($fichier,"w");
 fputs ($fp,"<?php\n");
 fputs($fp,"Header('Pragma:Public');\n");
 fputs ($fp,"include(\"../../../include/vars_adm.php\");\n");
 fputs ($fp,"include(\"../../../include/util.inc.php\");\n");
 fputs ($fp,"include(\"../../../lib/fpdf.php\");\n");
 fputs ($fp,"\$pdf=new FPDF(\"P\",\"cm\",\"A4\"); \n");
 fputs ($fp,"\$pdf->Open();\n");
 fputs ($fp,"\$pdf->SetDrawColor(80,100,142);\n");
 fputs ($fp,"\$pdf->SetAutoPageBreak(true, 1.5);\n");

 //fputs ($fp,"\$pdf->AddPage();\n");
 fclose($fp);
 }


}

function cree_entete_pdf($fichier,$npr,$etab) {
 global $etab_rne, $DATA, $page_pdf, $MODULE, $etab_nb_validations;
 $aujourdhui = date("d/m/Y");
 //Recherche du logo perso de l'tab
 $chetab="$DATA/$etab_rne/images/";
 creertousrep($chetab);
 $logo=getfilepath("ministere2.jpg",$chetab,"../images/");
 $logo="../../".$logo;
 $etab=stripslashes($etab);

if ($MODULE=="GiSCCo")  $exam="B2i";
    else $exam="C2i";
 if ($fichier=="0") { //Mode RAM
   global $pophtm;
  $pophtm.="\$pdf->SetFillColor(233,233,233);\n";
  $pophtm.="\$pdf->SetFont(\"Arial\",\"B\",14);\n";
  $pophtm.="\$pdf->SetTextColor(132,0,132);\n";
  $pophtm.="\$w=0.6+\$pdf->GetStringWidth(\"$npr\");\n";
  $pophtm.="\$pdf->Cell(\$w,1.2,\"$npr\",0,0,\"C\",1);\n";
  $pophtm.="\$pdf->SetFont(\"Times\",\"I\",10);\n";
  $pophtm.="\$pdf->SetTextColor(0,0,0);\n";
  $pophtm.="\$w=17-\$w;\n";
  $pophtm.="\$pdf->Cell(\$w,1.2,\"$etab\",0,1,\"R\",1);\n";
  $pophtm.="\$pdf->Image(\"$logo\",18.5,1,2);\n";
  $pophtm.="\$pdf->SetFont(\"Times\",\"I\",10);\n";
  $pophtm.="\$pdf->SetTextColor(0,0,0);\n";
  $pophtm.="\$pdf->Cell(3.5,1.2,\"$aujourdhui\",0,0,\"C\",1);\n";
  $pophtm.="\$pdf->SetFont(\"Arial\",\"B\",12);\n";
  $pophtm.="\$pdf->SetTextColor(0,0,132);\n";
  $pophtm.="\$pdf->Cell(0,1.2,\"Validation des comptences du ".$exam."\",0,1,\"C\");\n";


 } else { //Mode classique fichier
 $fp=fopen($fichier,"a");

 fputs ($fp,"\$pdf->SetMargins(0.6,0.8,0.8,0.8);\n");
 fputs ($fp,"\$pdf->AddPage();\n");
 fputs ($fp,"\$pdf->SetFillColor(233,233,233);\n");
 fputs ($fp,"\$pdf->SetFont(\"Arial\",\"B\",14);\n");
 fputs ($fp,"\$pdf->SetTextColor(132,0,132);\n");
 fputs ($fp,"\$w=0.6+\$pdf->GetStringWidth(\"$npr\");\n");
 fputs ($fp,"\$pdf->Cell(\$w,1.2,\"$npr\",0,0,\"C\",1);\n");
 fputs ($fp,"\$pdf->SetFont(\"Times\",\"I\",10);\n");
 fputs ($fp,"\$pdf->SetTextColor(0,0,0);\n");
 fputs ($fp,"\$w=17-\$w;\n");
 fputs ($fp,"\$wetab=\$pdf->GetStringWidth(\"$etab\");\n");
 //Si le nom d'tab est trop long on finit la ligne  vide
 fputs ($fp,"if (\$w>\$wetab) \$pdf->Cell(\$w,1.2,\"$etab\",0,1,\"R\",1);\n");
 fputs ($fp,"else { \n \$pdf->Cell(\$w,1.2,\" \",0,1,\"R\",1);\n");
 fputs ($fp," \$pdf->Cell(17,0.7,\"$etab\",0,1,\"C\",1);\n");
 fputs ($fp,"}\n");
 
 fputs ($fp,"\$pdf->Image(\"$logo\",18.5,1,2);\n");
 fputs ($fp,"\$pdf->SetFont(\"Times\",\"I\",10);\n");
 fputs ($fp,"\$pdf->SetTextColor(0,0,0);\n");
 fputs ($fp,"\$pdf->Cell(3.5,1.2,\"$aujourdhui\",0,0,\"C\",1);\n");
 fputs ($fp,"\$pdf->SetFont(\"Arial\",\"B\",14);\n");
 fputs ($fp,"\$pdf->SetTextColor(0,0,132);\n");
 fputs ($fp,"\$pdf->Cell(0,1.2,\"            Validation des comptences du ".$exam."\",0,1,\"L\");\n");
 //Un peu d'espace avant les rubriques
 //if ($etab_nb_validations>1) $libelle="'A' signifie que l'item est acquis'";
 //fputs ($fp,"\$pdf->SetFont(\"Times\",\"I\",9);\n");
 //fputs ($fp,"\$pdf->Cell(19,0.6,\"\",0,1);\n");
 fclose($fp);
 } //Fin mode fichier
}

function ajout_rub_pdf($fichier,$rub,$s,$ln) {
global $identite, $etab_quote;
//si $ln==1 il y a un saut de ligne avant chaque rubrique (1niveau)
 $fp=fopen($fichier,"a");
 $h=0.6;
 $rub = stripslashes($rub);
 if ($fichier=="0") { //Mode RAM
 global $pophtm;
 //Saut de page au chgt de niveau fait par cree_entete
 if ($s)  cree_entete_pdf($fichier,$identite,$etab_quote);

 $pophtm.="\$pdf->SetFont(\"Times\",\"B\",12);\n";
 $pophtm.="\$pdf->SetTextColor(115,24,57);\n";
 $pophtm.="\$pdf->Cell(19,0.4,\"\",0,1);\n";
 $pophtm.="\$pdf->MultiCell(19,$h,\"$rub\",0,1);\n";

 } else { //Mode fichier
  //Saut de page au chgt de niveau fait par cree-entete
 if ($s)  cree_entete_pdf($fichier,$identite,$etab_quote);

 if ($ln>0) fputs ($fp,"\$pdf->Ln($ln);\n"); 
 //Si on est trop bas, on change de page
 fputs ($fp,"\$yy=\$pdf->GetY();\n");
 fputs ($fp,"if (\$yy>24)\$pdf->AddPage();\n");
 
 fputs ($fp,"\$pdf->SetFont(\"Times\",\"B\",11);\n");
 fputs ($fp,"\$pdf->SetTextColor(115,24,57);\n");
 fputs ($fp,"\$pdf->Cell(19,0.4,\"\",0,1);\n");
 fputs ($fp,"\$pdf->MultiCell(19,$h,\"$rub\",0,1);\n");
 }
}

function ajout_item_pdf($fichier,$res,$item,$disc_val="") {
 //Dernier modle pour niveaux 2 ou 3
 //Avec disciplines et profs pour 1 ou 2 validations de l'item
  global $etab_nb_validations;
 //Taille de la bote des disciplines et de la police
 $dbox=4.4; 	$ditem=15; $dpol=8;
	
 $fp=fopen($fichier,"a");
 $h=0.5;
// $t=addslashes($item);
 $t=$item;
 if ($fichier=="0") { //Mode RAM
  global $pophtm;
  $pophtm.="\$pdf->SetFont(\"Times\",\"B\",10);\n";
  $pophtm.="\$pdf->SetTextColor(132,0,132);\n";
  $pophtm.="\$pdf->Cell(2,$h,\"$res\",1,0,\"C\",1);\n";
  $pophtm.="\$pdf->SetTextColor(0,0,132);\n";
  $pophtm.="\$pdf->SetFont(\"Times\",\"I\",9);\n";
  $pophtm.="\$pdf->MultiCell(16.8,$h,\"$t\",1,\"L\");\n";

  } else { //Mode fichier
 
 //Si on est trop bas, on change de page
 fputs ($fp,"\$yy=\$pdf->GetY();\n");
 fputs ($fp,"if (\$yy>26.9)\$pdf->AddPage();\n");
 
  //Stockage dbut ligne
 fputs ($fp,"\$xx=\$pdf->GetX();\n");
 fputs ($fp,"\$yy=\$pdf->GetY();\n");
 fputs ($fp, "\$fin=\$pdf->GetY();\n");
 
 //L'item sera sur deux lignes sssi nb_validations>1 et le reste suivra
 //Sauf pour les items dj sur 2 lignes !
 $sauf='C.2.1 C.2.2 C.3.3 C.3.7 C.4.2 C.4.5 L.1.5 L.2.4 L.2.6 L.3.3 L.3.6 L 3.6 L.5.3';
 $debitem=substr($item,0,5);
 if (($etab_nb_validations>1) AND (strpos($sauf,$debitem)===false)) $t.="\n ";
 
 //Affichage texte item en 1 ou 2 lignes suivant item
 fputs ($fp,"\$pdf->SetTextColor(0,0,132);\n");
 fputs ($fp,"\$pdf->SetFont(\"Times\",\"I\",9);\n");
 fputs ($fp,"\$pdf->MultiCell($ditem,$h,\"$t\",1,\"L\");\n");
 //Jusqu'o est-on descendu ?
 fputs ($fp,"\$yyy=\$pdf->GetY();\n");
 //Retour fin multicell
 fputs ($fp,"\$xx+=$ditem;\n");
 fputs ($fp,"\$pdf->SetXY(\$xx,\$yy);\n");

 //Affichage rsultat A ou vide 
 //Hauteur auto suivant Multicell prcdente
 fputs ($fp,"\$haut=\$yyy-\$yy;\n");
 fputs ($fp,"if (\$haut>0.5) \$epsilon=\"\\n \"; else \$epsilon='';\n");
 fputs ($fp,"\$pdf->SetFont(\"Times\",\"B\",10);\n");
 fputs ($fp,"\$pdf->SetTextColor(132,0,132);\n");
 fputs ($fp,"\$pdf->MultiCell(0.5,$h,\"$res\".\$epsilon,\"LBT\",\"L\",1);\n");
 //Retour fin multicell
 fputs ($fp,"\$xx+=0.5;\n");
 fputs ($fp,"\$pdf->SetXY(\$xx,\$yy);\n");

 //Bote vide pour y coller les disciplines
 fputs ($fp,"\$pdf->Cell($dbox,\$haut,\"\".\$epsilon,\"TBR\",0,\"L\",1);\n");

 //discipline validatrice
 //fputs ($fp,"if ((\$yyy-\$yy)>0.5) \$epsilon=\"\\n \"; else \$epsilon='';\n"); 
 fputs ($fp,"\$pdf->SetXY(\$xx,\$yy);\n");
 fputs ($fp,"\$pdf->SetFont(\"Times\",\"I\",$dpol);\n");
 fputs ($fp,"\$pdf->MultiCell($dbox,$h,\"$disc_val\",\"0\",\"L\",0);\n");
 fputs ($fp,"\$x3=\$pdf->GetX();\n");
 fputs ($fp,"\$y3=\$pdf->GetY();\n"); 
 fputs ($fp,"if (\$yyy>\$y3) \$y3=\$yyy;\n");
 fputs ($fp,"\$pdf->SetXY(\$x3,\$y3);\n");
 //pret pour ligne suivante
 
 
 
 fclose($fp);
 }
}

function ajout_item1_pdf($fichier,$res,$item) {
	//Classique pour niveau 1 ou pour GiCii ou Melia
 $fp=fopen($fichier,"a");
 $h=0.5;
// $t=addslashes($item);
 $t=$item;
 if ($fichier=="0") { //Mode RAM
  global $pophtm;
  $pophtm.="\$pdf->SetFont(\"Times\",\"B\",10);\n";
  $pophtm.="\$pdf->SetTextColor(132,0,132);\n";
  $pophtm.="\$pdf->Cell(2,$h,\"$res\",1,0,\"C\",1);\n";
  $pophtm.="\$pdf->SetTextColor(0,0,132);\n";
  $pophtm.="\$pdf->SetFont(\"Times\",\"I\",9);\n";
  $pophtm.="\$pdf->MultiCell(17.6,$h,\"$t\",1,1);\n";

  } else { //Mode fichier
 fputs ($fp,"\$pdf->SetFont(\"Times\",\"B\",10);\n");
 fputs ($fp,"\$pdf->SetTextColor(132,0,132);\n");
 fputs ($fp,"\$pdf->Cell(2,$h,\"$res\",1,0,\"C\",1);\n");

 fputs ($fp,"\$pdf->SetTextColor(0,0,132);\n");
 fputs ($fp,"\$pdf->SetFont(\"Times\",\"I\",9);\n");

 fputs ($fp,"\$pdf->MultiCell(17.6,$h,\"$t\",1,1);\n");
 fclose($fp);
 }
}

function ajout_item2_pdf($fichier,$res,$item) {
	//Avec espace en fin d'item pour le primaire au choix utilisateur
 $fp=fopen($fichier,"a");
 $h=0.5;
// $t=addslashes($item);
 $t=$item;
 if ($fichier=="0") { //Mode RAM
  global $pophtm;
  $pophtm.="\$pdf->SetFont(\"Times\",\"B\",10);\n";
  $pophtm.="\$pdf->SetTextColor(132,0,132);\n";
  $pophtm.="\$pdf->Cell(2,$h,\"$res\",1,0,\"C\",1);\n";
  $pophtm.="\$pdf->SetTextColor(0,0,132);\n";
  $pophtm.="\$pdf->SetFont(\"Times\",\"I\",9);\n";
  $pophtm.="\$pdf->MultiCell(16.8,$h,\"$t\",1,1);\n";

  } else { //Mode fichier
 fputs ($fp,"\$pdf->SetFont(\"Times\",\"B\",10);\n");
 fputs ($fp,"\$pdf->SetTextColor(132,0,132);\n");
 fputs ($fp,"\$pdf->Cell(2,$h,\"$res\",1,0,\"C\",1);\n");

 fputs ($fp,"\$pdf->SetTextColor(0,0,132);\n");
 fputs ($fp,"\$pdf->SetFont(\"Times\",\"I\",9);\n");
 
 //Essai recup position et page
 fputs ($fp,"\$xx=\$pdf->GetX();\n");
 fputs ($fp,"\$yy=\$pdf->GetY();\n");
 fputs ($fp,"\$pageno=\$pdf->PageNo();\n");
 fputs ($fp,"\$xx+=10.8;\n");

 fputs ($fp,"\$pdf->MultiCell(10.8,$h,\"$t\",1,\"L\",0);\n");
 fputs ($fp,"if (\$pageno==\$pdf->PageNo()) { \n");
   fputs ($fp,"\$yyy=\$pdf->GetY();\n");
   fputs ($fp,"\$ofset=\$yyy-\$yy;\n");
   fputs ($fp,"if (\$ofset>$h*3) \$ofset=$h;\n");
 
   //Retour fin multicell
   fputs ($fp,"\$pdf->SetXY(\$xx,\$yy);\n");
   fputs ($fp,"\$pdf->Cell(6,\$ofset,\"\",\"1\",1,\"L\",0);\n");
 fputs ($fp,"} \n");
   
 fclose($fp);
 }
}

function ferme_pdf($fichier) {
 if ($fichier=="0") { //Mode RAM
  global $pophtm;

  $pophtm.="\$pdf->Output();\n";
  $pophtm.="?>\n";

  } else { //Mode fichier
 $fp=fopen($fichier,"a");
 fputs ($fp,"\$pdf->Output();\n");
 fputs ($fp,"?>\n");  //<?
 fclose($fp);
  }

}

function cree_fich_etiq($fichier) {
$fp=fopen($fichier,"w");	
fputs ($fp,"setlocale (LC_TIME, 'fr_FR.ISO_8859-1', 'fr_FR','fr_fr','fr','fra','fr_FR@euro');\n");
fputs ($fp,"include(\"../lib/fpdf.php\");\n");
fputs ($fp,"\$date_pdf = date(\"d/m/Y\");\n");
fputs ($fp,"\$mois_pdf = strftime(\"%B %Y\", mktime(0, 0, 0, date('m'), date('d'), date('Y')));\n");
fputs ($fp,"\$title = \"Etiquettes des rsultats du B2i - \$etab_nom (\$date_pdf)\";\n");
fputs ($fp,"\$pdf=new FPDF('P','mm','A4');\n");
fputs ($fp,"\$pdf->SetMargins(10,10,10);\n");
fputs ($fp,"\$pdf->SetAuthor('CATICE Acadmie de Bordeaux');\n");
fputs ($fp,"\$pdf->SetCreator('GiBii/Mlia');\n");
fputs ($fp,"\$pdf->SetTitle($title);\n");
fputs ($fp,"\$pdf->SetDrawColor(200);\n");
fputs ($fp,"\$pdf->SetLineWidth(0.1);\n");

fclose($fp);	
}



} //Ne pas supprimer, fin de !isset
?>