#========================================================================== #
# Project Filename:    D:\PHP\b2i\doc\meligibii.last.dez                    #
# Project Name:        GiBii / Melia                                        #
# Author:              DD - JM                                              #
# DBMS:                MySQL 4                                              #
# Copyright:           DD - JM                                              #
# Generated on:        25/11/2007 11:34:41                                  #
#========================================================================== #

#========================================================================== #
#  Tables                                                                   #
#========================================================================== #

CREATE TABLE eleves (
    eleve_id INTEGER NOT NULL AUTO_INCREMENT,
    nom VARCHAR(30) NOT NULL,
    prenom VARCHAR(25) NOT NULL,
    civil ENUM('M.','Mme','Mlle') NOT NULL DEFAULT 'M.',
    dnaiss VARCHAR(12) NOT NULL,
    ident_nat VARCHAR(32),
    uid VARCHAR(20) NOT NULL DEFAULT '',
    imp_diplome VARCHAR(5),
    tag INTEGER NOT NULL DEFAULT 0,
    annee INTEGER NOT NULL,
    lastdisc TINYINT DEFAULT -1,
    classe_id INTEGER NOT NULL,
    compte_id INTEGER,
    etab_id INTEGER NOT NULL,
    CONSTRAINT PK_eleves PRIMARY KEY (eleve_id),
    KEY IDX_eleves1(nom, prenom, tag),
    KEY IDX_eleves2(etab_id, annee, tag),
    KEY IDX_eleves3(compte_id)
);

CREATE TABLE profs (
    prof_id INTEGER NOT NULL AUTO_INCREMENT,
    nom VARCHAR(30) NOT NULL,
    civil ENUM('M.','Mme','Mlle') NOT NULL DEFAULT 'Mme',
    dnaiss VARCHAR(12) NOT NULL,
    prenom VARCHAR(25),
    ident_nat VARCHAR(32),
    uid VARCHAR(20) NOT NULL DEFAULT '',
    admin INTEGER UNSIGNED NOT NULL DEFAULT 0,
    tag INTEGER NOT NULL DEFAULT 0,
    annee INTEGER NOT NULL,
    compte_id INTEGER,
    etab_id INTEGER NOT NULL,
    disc_id INTEGER NOT NULL DEFAULT -1,
    opt_dem1an TINYINT DEFAULT 0,
    CONSTRAINT PK_profs PRIMARY KEY (prof_id),
    KEY IDX_profs1(nom, prenom, tag),
    KEY IDX_profs2(etab_id, annee, tag),
    KEY IDX_profs3(compte_id)
);

CREATE TABLE classes (
    classe_id INTEGER NOT NULL AUTO_INCREMENT,
    divcod VARCHAR(12) NOT NULL,
    divgro CHAR(1) DEFAULT 'D',
    etab_id INTEGER NOT NULL,
    CONSTRAINT PK_classes PRIMARY KEY (classe_id),
    KEY IDX_classes1(etab_id)
);

CREATE TABLE lien_profs_classes (
    prof_id INTEGER NOT NULL,
    classe_id INTEGER NOT NULL,
    KEY idx_prof_id(prof_id),
    KEY IDX_lien_profs_classes2(classe_id)
);

CREATE TABLE items (
    item_id INTEGER NOT NULL AUTO_INCREMENT,
    brevet_no INTEGER,
    rub_no INTEGER NOT NULL,
    s_rub_no INTEGER,
    obligatoire TINYINT NOT NULL DEFAULT 1,
    CONSTRAINT PK_items PRIMARY KEY (item_id),
    KEY IDX_items1(brevet_no, rub_no)
);

CREATE TABLE demandes (
    message_id INTEGER NOT NULL AUTO_INCREMENT,
    quand DATETIME NOT NULL,
    commentaire TEXT,
    obtenue TINYINT,
    active TINYINT,
    nboui TINYINT,
    nbnon TINYINT,
    longue TINYINT,
    eleve_id INTEGER NOT NULL,
    item_id INTEGER NOT NULL,
    disc_id INTEGER,
    CONSTRAINT PK_demandes PRIMARY KEY (message_id),
    KEY IDX_demandes1(eleve_id, disc_id)
);

CREATE TABLE reponses (
    reponse_id INTEGER NOT NULL AUTO_INCREMENT,
    accord BOOL NOT NULL DEFAULT 0,
    quand DATETIME,
    commentaire TEXT,
    message_id INTEGER,
    prof_id INTEGER NOT NULL,
    CONSTRAINT PK_reponses PRIMARY KEY (reponse_id),
    KEY idx_message_id(message_id),
    KEY IDX_reponses2(prof_id)
);

CREATE TABLE resultats (
    resultat_id INTEGER NOT NULL AUTO_INCREMENT,
    quand DATETIME NOT NULL,
    eleve_id INTEGER NOT NULL,
    item_id INTEGER NOT NULL,
    disc_id INTEGER DEFAULT 0,
    CONSTRAINT PK_resultats PRIMARY KEY (resultat_id),
    KEY ix_elitdi(eleve_id, item_id, disc_id)
);

CREATE TABLE rubriques (
    rub_no INTEGER NOT NULL,
    libelle TEXT,
    rub_simple VARCHAR(55),
    CONSTRAINT PK_rubriques PRIMARY KEY (rub_no)
);

CREATE TABLE comptes (
    compte_id INTEGER NOT NULL AUTO_INCREMENT,
    login VARCHAR(22),
    mdp CHAR(32) NOT NULL DEFAULT '',
    statut ENUM('Eleve', 'Prof', 'Admin', 'Gest','Sadmin','Parent','Autre') NOT NULL,
    theme VARCHAR(128) DEFAULT '',
    actif INTEGER DEFAULT 1,
    precdate INTEGER,
    nbsessions INTEGER DEFAULT 0,
    ip INTEGER,
    machinecliente VARCHAR(32),
    prof_id INTEGER,
    eleve_id INTEGER,
    etab_id INTEGER NOT NULL,
    CONSTRAINT PK_comptes PRIMARY KEY (compte_id),
    KEY IDX_comptes1(login, etab_id),
    KEY IDX_comptes2(eleve_id),
    KEY IDX_comptes3(prof_id)
);

CREATE TABLE libelles (
    item_id INTEGER NOT NULL,
    inst TEXT NOT NULL,
    base TEXT NOT NULL,
    CONSTRAINT PK_libelles PRIMARY KEY (item_id)
);

CREATE TABLE disciplines (
    disc_id INTEGER NOT NULL,
    libelle VARCHAR(60),
    code_langue VARCHAR(2) DEFAULT 'Fr',
    CONSTRAINT PK_disciplines PRIMARY KEY (disc_id)
);

CREATE TABLE etablissements (
    etab_id INTEGER NOT NULL AUTO_INCREMENT,
    type_id INTEGER NOT NULL,
    rne CHAR(8) NOT NULL,
    nom VARCHAR(50) NOT NULL,
    adresse VARCHAR(255),
    codepostal VARCHAR(6),
    ville VARCHAR(50),
    mail_admin VARCHAR(40),
    tel_admin VARCHAR(20),
    typauth_id INTEGER NOT NULL DEFAULT 1,
    theme VARCHAR(20) NOT NULL DEFAULT 'standard',
    chgt_theme TINYINT DEFAULT 1,
    theme_eleve_limite TINYINT NOT NULL DEFAULT 0,
    menus_CSS TINYINT DEFAULT 0,
    pas_aide_eleve TINYINT NOT NULL DEFAULT 0,
    pas_aide_prof TINYINT NOT NULL DEFAULT 0,
    pas_aide_admin TINYINT NOT NULL DEFAULT 0,
    URL_aide_eleve VARCHAR(100),
    URL_aide_prof VARCHAR(100),
    URL_aide_admin VARCHAR(100),
    niveau ENUM('niv1','niv2','niv3','niv12','niv23','niv123') NOT NULL,
    nb_validations INTEGER NOT NULL DEFAULT 2,
    nbj_vie_demande INTEGER NOT NULL DEFAULT 30,
    nb_max_demandes INTEGER NOT NULL DEFAULT 2,
    nb_max_refus INTEGER DEFAULT 0,
    modele_login_e VARCHAR(20) NOT NULL DEFAULT 'ppp.nnn',
    modele_login_p VARCHAR(20) NOT NULL DEFAULT 'pn',
    mdp_eleve TINYINT NOT NULL DEFAULT 1,
    mdp_prof TINYINT NOT NULL DEFAULT 1,
    fiche_profs TINYINT NOT NULL DEFAULT 1,
    stats_profs TINYINT NOT NULL DEFAULT 1,
    pop_profs TINYINT DEFAULT 1,
    vouvoyer_elev TINYINT DEFAULT 0,
    valid_profs TINYINT NOT NULL DEFAULT 1,
    result_profs TINYINT NOT NULL DEFAULT 1,
    groupes_profs TINYINT DEFAULT 0,
    actif INTEGER DEFAULT 1,
    alert_message_vide TINYINT NOT NULL DEFAULT 0,
    sess_timeout INTEGER NOT NULL DEFAULT 7200,
    recul_stats INTEGER DEFAULT 30,
    last_proc_local DATETIME DEFAULT '2000-01-01',
    profslongs INTEGER DEFAULT 0,
    fposition TINYINT NOT NULL DEFAULT 1,
    attestation VARCHAR(2) NOT NULL DEFAULT 'A5',
    CONSTRAINT PK_etablissements PRIMARY KEY (etab_id),
    UNIQUE (rne),
    KEY IDX_etablissements1(rne)
);

CREATE TABLE _params_globaux (
    param_nom VARCHAR(32) NOT NULL,
    param_type ENUM('i','s','a') NOT NULL,
    param_val TEXT,
    param_desc VARCHAR(255),
    param_tag INTEGER NOT NULL DEFAULT 0,
    CONSTRAINT PK__params_globaux PRIMARY KEY (param_nom)
);

CREATE TABLE libelles_perso (
    item_id INTEGER NOT NULL,
    libelle TEXT NOT NULL,
    etab_id INTEGER NOT NULL,
    KEY IDX_libelles_perso1(etab_id, item_id)
);

CREATE TABLE disc_gep (
    gep_id VARCHAR(8) NOT NULL,
    disc_id INTEGER NOT NULL,
    CONSTRAINT PK_disc_gep PRIMARY KEY (gep_id)
);

CREATE TABLE lien_eleves_disciplines (
    rang TINYINT,
    eleve_id INTEGER NOT NULL,
    disc_id INTEGER NOT NULL,
    KEY IDX_lien_eleves_disciplines1(eleve_id),
    KEY IDX_lien_eleves_disciplines2(disc_id)
);

CREATE TABLE lien_eleves_classes (
    eleve_id INTEGER NOT NULL,
    classe_id INTEGER NOT NULL,
    KEY IDX_lien_eleves_classes1(eleve_id),
    KEY IDX_lien_eleves_classes2(classe_id)
);

CREATE TABLE _params_auth (
    param_id INTEGER NOT NULL AUTO_INCREMENT,
    etab_id INTEGER NOT NULL,
    param_nom VARCHAR(40),
    param_type ENUM('i','s','a'),
    param_val VARCHAR(40),
    param_desc VARCHAR(40),
    param_tag TINYINT DEFAULT -1,
    PRIMARY KEY (param_id),
    UNIQUE KEY ix_etb_n(etab_id, param_nom)
);

CREATE TABLE types_auth (
    typauth_id INTEGER NOT NULL AUTO_INCREMENT,
    nom VARCHAR(40),
    extra VARCHAR(40),
    PRIMARY KEY (typauth_id)
);

CREATE TABLE changements_logins (
    etab_id INTEGER NOT NULL,
    loginold VARCHAR(30),
    loginnew VARCHAR(30),
    nom VARCHAR(30),
    prenom VARCHAR(30),
    statut VARCHAR(10),
    annee INTEGER,
    dateconnexion INTEGER
);

CREATE TABLE erreurs_logins (
    erid INTEGER NOT NULL AUTO_INCREMENT,
    quand DATETIME,
    compte_id INTEGER,
    etab_id INTEGER,
    ip VARCHAR(40),
    code ENUM('ETB','LOG','GDS','MDP','PAG','PER','XSS','TMO','STA','EXP'),
    login VARCHAR(25),
    nom VARCHAR(25),
    prenom VARCHAR(25),
    statut VARCHAR(10),
    etnom VARCHAR(40),
    etville VARCHAR(40),
    etcp VARCHAR(6),
    complet TINYINT DEFAULT 0,
    PRIMARY KEY (erid),
    KEY IDX_Entity_12(etab_id),
    KEY IDX_erreurs_logins3(code),
    KEY IDX_erreurs_logins4(quand)
);

CREATE TABLE lpi (
    prof_id INTEGER,
    item_id INTEGER,
    KEY IDX_lpi1(prof_id),
    KEY IDX_lpi2(item_id)
);

CREATE TABLE averts (
    avert_id INTEGER NOT NULL AUTO_INCREMENT,
    code ENUM('refusdem','s2admins'),
    luquand DATETIME,
    texte_id INTEGER,
    to_id INTEGER,
    PRIMARY KEY (avert_id),
    KEY IDX_avert1(to_id)
);

CREATE TABLE textes (
    texte_id INTEGER NOT NULL AUTO_INCREMENT,
    texte TEXT,
    ecritquand DATETIME,
    attributs VARCHAR(255),
    from_id VARCHAR(40),
    suivant INTEGER DEFAULT 0,
    PRIMARY KEY (texte_id)
);

CREATE TABLE brevets (
    bid INTEGER NOT NULL AUTO_INCREMENT,
    eleve_id INTEGER NOT NULL,
    niveau TINYINT NOT NULL,
    datebrev DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
    PRIMARY KEY (bid),
    KEY IDX_eid(eleve_id)
);

CREATE TABLE connexions (
    quand DATETIME,
    ip INTEGER,
    machinecliente VARCHAR(255),
    compte_id INTEGER
);

CREATE TABLE lrp (
    resultat_id INTEGER NOT NULL,
    prof_id INTEGER NOT NULL,
    quand DATETIME,
    UNIQUE KEY ix_rt(resultat_id, prof_id)
);

CREATE TABLE typetab (
    type_id INTEGER NOT NULL AUTO_INCREMENT,
    type VARCHAR(10) NOT NULL,
    libelle VARCHAR(40),
    PRIMARY KEY (type_id)
);

CREATE TABLE divers (
	divers_id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY ,
	motcle VARCHAR( 50 ) NULL ,
	id INT NULL ,
	etab_id INT NULL,
	vrac BLOB NULL ,
	INDEX ( motcle , id )
); 