<?php
#=
//ce tableau est utilis pour le backup et le restore qui sont des algorithmes
//guids par son contenu (celui du tableau !).
//Les valeurs de l'indice de la premire dimension du tableau sont les tables
//qu'il faut sauver ou restaurer.
//Les tables qui n'y sont pas sont des tables de constantes :
//  _params_globaux, disc_gep, disciplines, types_auth.

//Pour ces tables :
// - 'cle' est la cl primaire autonumber lorsqu'elle existe
// - 'garder' signifie qu'il faudra garder dans un tableau la correspondance
//    entre ancienne et nouvelle cl primaire (le nouvel autonumber).
// - 'etab' indique si etab_id est une cl trangre de la table
 
 
function getguide($table,$entree) {
global $guide;
$valeur=@$guide[$table][$entree];
if (isset($valeur)) return $valeur;
else return 0;
}

$guide=array(
//cas un peu particulier pour l'algorithme, mais il faut bien la stocker !
    'etablissements' 
		=> array(
						'cle'    => 'etab_id',
                       	'etab'   => 0,
						'fonct'	 => 'restore_etab'),
                       	
//2 tables faciles  stocker.
//classes doit tre stocke au dbut pour la cl trangre de 'eleves'
    'classes' 		
		=> array(
						'cle'    => 'classe_id',
                       	'etab'   => 1,
						'fonct'	 => 'restore_cla'),
						
	'divers'
		=> array(
						'cle'	=> 'divers_id',
						'etab'	=> 1,
						'fonct' => 'restore_divers'),

    'libelles_perso' 
		=> array(
						'cle'    => '',
                       	'etab'   => 1,
						'fonct'	 => 'restore_libperso_parauth'),
						

					   
//2 tables stockes telles quelles, 
    'eleves'  				
		=> array(
						'cle'    => 'eleve_id',
                       	'etab'   => 1,
						'fonct'	 => 'restore_eleves'),
                       
    'profs'   				
		=> array(
						'cle'    => 'prof_id',
                       	'etab'   => 1,
						'fonct'	 => 'restore_profs'),

//pour ces tables, les nouvelles valeurs des cls trangres sont toutes connues
//(demandes permet de connatre juste avant une cl trangre pour reponses)
    'comptes' 				
		=> array(
						'cle'    => 'compte_id',
                       	'etab'   => 1,
						'fonct'	 => 'restore_comptes'),
                       	
    'resultats'  
		=> array(
						'cle'    => 'resultat_id',
                       	'etab'   => 0,
						'from'	 => 'resultats,eleves',
						'where'	 => 'resultats.eleve_id=eleves.eleve_id
									 AND eleves.etab_id=',
						'fonct'	 => 'restore_res_bre'),

    'brevets'  
		=> array(
						'cle'	=> 'bid',
    		  		   	'etab'	=> 0,
						'from'	 => 'brevets,eleves',
						'where'	 => 'brevets.eleve_id=eleves.eleve_id
									 AND eleves.etab_id=',
						'fonct'	 => 'restore_res_bre'),


    'demandes'				
		=> array(
						'cle'    => 'message_id',
                       	'etab'   => 0,
						'from'	 => 'demandes,eleves',
						'where'	 => 'demandes.eleve_id=eleves.eleve_id
									 AND eleves.etab_id=',
						'fonct'	 => 'restore_dem'),
						
    'reponses'				
		=> array(
						'cle'    => 'reponse_id',
                       	'etab'   => 0,
						'from'	 => 'reponses,demandes,eleves',
						'where'	 => 'reponses.message_id=demandes.message_id
									 AND demandes.eleve_id=eleves.eleve_id
									 AND eleves.etab_id=',
						'fonct'	 => 'restore_rep'), 	//les enrg 'suivent' les lves et non les profs !
									 
						
    'lien_eleves_disciplines' 
		=> array(
						'cle'    => '',
                       	'etab'   => 0,
						'from'	 => 'lien_eleves_disciplines,eleves',
						'where'	 => 'lien_eleves_disciplines.eleve_id=eleves.eleve_id
									 AND eleves.etab_id=',
						'fonct'	 => 'restore_led_lec'),
						
                       	
    'lien_eleves_classes'  
		=> array(
						'cle'    => '',
                       	'etab'   => 0,
						'from'	 => 'lien_eleves_classes,eleves',
						'where'	 => 'lien_eleves_classes.eleve_id=eleves.eleve_id
									 AND eleves.etab_id=',
						'fonct'	 => 'restore_led_lec'),
						
						
    'lrp'  
		=> array(
						'cle'    => '',
                       	'etab'   => 0,
						'from'	 => 'lrp,resultats,eleves',
						'where'	 => 'lrp.resultat_id=resultats.resultat_id
									 AND resultats.eleve_id=eleves.eleve_id
									 AND eleves.etab_id=',
						'fonct'	 => 'restore_lrp'), //c'est une table d'lves et non de profs !

									 
    'lpi'  
		=> array(
						'cle'    => '',
                       	'etab'   => 0,
						'from'	 => 'lpi,profs',
						'where'	 => 'lpi.prof_id=profs.prof_id
									 AND profs.etab_id=',
						'fonct'	 => 'restore_lpc_lpi'),
						
    'lien_profs_classes' 
		=> array(
						'cle'    => '',
                       	'etab'   => 0,
						'from'	 => 'lien_profs_classes,profs',
						'where'	 => 'lien_profs_classes.prof_id=profs.prof_id
									 AND profs.etab_id=',
						'fonct'	 => 'restore_lpc_lpi'),
                       	
    '_params_auth'  
		=> array(
						'cle'    => 'param_id',
                       	'etab'   => 1,
						'fonct'	 =>'restore_libperso_parauth')
	);
                       	
                       	

?>