<?php
#=
/****************************************************************************
Copyright 2002, Daniel Deycard, Jacques Messines, Stphanie Roussel, Jean-Marie Treins
(CATICE Acadmie de Bordeaux)

This file is part of GiBii/Melia.

GiBii/Melia is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

GiBii/Melia is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GiBii/Melia; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/
include("../include/vars_adm.php");
include("../include/util.inc.php");
include("../include/get.inc.php");
include("../include/attestations.inc.php");
set_time_limit(600);
$statut=$_REQUEST['statut'];
opensession($statut,false);

if (isset($_GET['action']) && is_file("$DATA/$etab_rne/diplomes/csv_result.csv")) {
	header('Expires: 0');
	if (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE')!== false)
		{
		if (strpos($_SERVER['HTTP_REFERER'], 'https://')!== false) 
		session_cache_limiter("private");
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Pragma: public');
		}
      	else {
		header('Pragma: no-cache');
		header('Content-Type: application/octet-stream');
		}
	$date_csv = date("Ymd");
	if($_GET['action'] == "csv") {
		header('Content-Disposition: attachment; filename="'.$etab_rne.'_'.$date_csv.'_result.csv"');
		readfile("$DATA/$etab_rne/diplomes/csv_result.csv");
		}
	if($_GET['action'] == "pdf") {
		$line_pdf = 0;
		$handle = fopen("$DATA/$etab_rne/diplomes/csv_result.csv", "r");
		while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) {
			$res_pdf[$line_pdf] = $data;
			$line_pdf++;
			}	
		fclose($handle);
		include("csv2pdf.php");
		}	
	die();
	}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<HTML>
<HEAD>
<meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
<TITLE>nom1</TITLE>
<BASE TARGET="_self">
<link rel="stylesheet" href="<?php echo "../themes/".$etab_theme."/b2i.css" ?>" type="text/css">
</HEAD>
<body class="arialadmin" link="white" vlink="white" alink="white">


<p class="sous_titre" align="center">Exportation des rsultats de l'tablissement au format CSV</p><hr>
<p align="left">
</p>
<p class='attention centre '>
			Veuillez patienter pendant la cration du fichier CSV...</p>
<?php
superflush();
connecte($host,$user,$mdp,$db);

//print_r($_SESSION);exit();
//Prparation fichier csv
creertousrep("$DATA/$etab_rne/diplomes/");
$csv_file="$DATA/$etab_rne/diplomes/csv_result.csv";
$fcsv=fopen($csv_file,"w");

//En-ttes de colonnes
switch ($MODULE) {
	case 'GiBii' :
		$tit="B2i";
		break;
	case 'GiCii' :
		$tit="C2i";
		break;
	case 'Melia' :
		$tit="CLV";
		break;
	default :
		$tit=$MODULE;
}
$lignecsv="RNE;Divcod;Nom;Prnom;Dnaiss";
for ($i=1;$i<4;$i++) $lignecsv.=";%items $i;".$tit.getlibellenivo($i);
$lignecsv.="\n";
fputs($fcsv,$lignecsv);

//recherche du nombre d'items par brevets
//---------------------------------------
$nbitems=array();   
$resitems=query("SELECT brevet_no, count(item_id) AS nb FROM items WHERE obligatoire=1 GROUP BY brevet_no");
while (list($brevet_no,$nb)=mysql_fetch_array($resitems)) 
	$nbitems[$brevet_no]=$nb;
	
//recherche des brevets obtenus par les lves
//--------------------------------------------
$brevets=array();
$resbrevets=query("	SELECT brevets.eleve_id,brevets.niveau FROM brevets,eleves 
					WHERE brevets.eleve_id=eleves.eleve_id
					  AND eleves.etab_id=$etab_id");
while (list($eleve_id,$niveau)=mysql_fetch_array($resbrevets)) 
	$brevets[$eleve_id][$niveau]=1;

//boucle principale : les pourcentages obtenus par chaque lve
//-------------------------------------------------------------

$reseleve=query("   SELECT classes.divcod, count( resultats.resultat_id ) AS nbresultats, 
							eleves.eleve_id, brevet_no, nom, prenom, dnaiss
					FROM eleves, resultats, items, classes
					WHERE resultats.eleve_id = eleves.eleve_id
					AND resultats.item_id = items.item_id
					AND items.obligatoire=1
					AND eleves.etab_id =$etab_id
					AND eleves.annee =$sess_ascol
					AND classes.classe_id = eleves.classe_id
					GROUP BY eleves.eleve_id, brevet_no
					ORDER BY classes.divcod, nom, prenom, items.item_id");
$nb_div = 0;
$oldeleve_id=0;
$olddivcod=0;					
while ($row=mysql_fetch_array($reseleve)) {
	$eleve_id=$row['eleve_id'];
	if ($eleve_id!=$oldeleve_id) {
		//vider l'lve prcdent
		if ($oldeleve_id) {
			for ($brevet_no=1; $brevet_no<=3 ; $brevet_no++) {
				if (isset($tliste[$brevet_no])) $ligne.=$tliste[$brevet_no];
				else $ligne.=";0;0";
				}
			fputs($fcsv,$ligne."\n");
			}
		$divcod=$row['divcod'];
		if ($divcod<>$olddivcod) {
			if ($nb_div == 0) print "<div style='text-align:center'>
			Classes traites :&nbsp;&nbsp;&nbsp;";  //Pour remettre le curseur  gauche !
			print "$divcod...  ";
			$nb_div++;
			flush();
			$olddivcod=$divcod;
			}
		$nom=$row['nom'];
		$prenom=$row['prenom'];
		$dnaiss=$row['dnaiss'];
		$oldeleve_id=$eleve_id;
		$ligne="$etab_rne;$divcod;$nom;$prenom;$dnaiss";
		$tliste=array(); //il faut vidanger !
		}
	$brevet_no=$row['brevet_no'];
	$nbresultats=$row['nbresultats'];
	$pcent=(int) ($row['nbresultats']*100/$nbitems[$brevet_no]);
	$liste=";$pcent";
	if (isset($brevets[$eleve_id][$brevet_no])) $liste.=';1'; 
	else $liste.=';0';
	$tliste[$brevet_no]=$liste;
	}
//Reste  finir le dernier lve
if ($oldeleve_id) { //on est entr dans la boucle
	for ($brevet_no=1; $brevet_no<=3 ; $brevet_no++) {
		if (isset($tliste[$brevet_no])) $ligne.=$tliste[$brevet_no];
		else $ligne.=";0;0";
		}
	fputs($fcsv,$ligne."\n");	
	}
fclose($fcsv);


//Affichage lien CSV... si il y a au moins UNE classe  exporter !
print "</div>
<br /><br /><br />
<div style='text-align:center'>
<table width='40%' border='0' style='margin: auto'>";
if ($nb_div > 0) print "<tr><td width='85%'class='paire centre encadre_loin'>Pour tlcharger le fichier cr...
		</td><td class='centre paire encadre_loin'>
		<a href='".$_SERVER['PHP_SELF']."?statut=".$statut."&action=csv' title='CSV' target='_top'><img src=\"../themes/".$etab_theme."/csv.gif\" border='0'  alt='CSV'></a>
		</td></tr>
		<tr><td width='85%'class='paire centre encadre_loin'>Pour tlcharger la feuille d'tiquettes...
		</td><td class='centre paire encadre_loin'>
		<a href='".$_SERVER['PHP_SELF']."?statut=".$statut."&action=pdf' title='PDF (pages de 8 tiquettes)' target='_top'><img src=\"../themes/".$etab_theme."/pdf_8.gif\" border='0'  alt='PDF'></a>		
		</td></tr>";
else print "<br /><table width='40%' border='0' style='margin: auto'>
		<tr><td class='paire centre encadre_loin'>Avant de vouloir exporter les rsultats, pensez  importer les utilisateurs...
		</td></tr>";
print "</table>";

flush();
?>

</BODY>
</HTML>