<?php
#=
/****************************************************************************
Copyright 2002, Daniel Deycard, Jacques Messines, Stphanie Roussel, Jean-Marie Treins
(CATICE Acadmie de Bordeaux)

This file is part of GiBii/Melia.

GiBii/Melia is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

GiBii/Melia is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GiBii/Melia; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/
setlocale (LC_TIME, 'fr_FR.ISO_8859-1', 'fr_FR','fr_fr','fr','fra','fr_FR@euro');
include("../lib/fpdf.php");
$date_pdf = date("d/m/Y");
$mois_pdf = strftime("%B %Y", mktime(0, 0, 0, date('m'), date('d'), date('Y')));

$title = "Etiquettes des rsultats du B2i - $etab_nom ($date_pdf)";
$filename = $etab_rne."_".$date_csv."_etiquettes.pdf";
$pdf=new FPDF('P','mm','A4');
$pdf->SetMargins(10,10,10);
$pdf->SetAuthor('CATICE Acadmie de Bordeaux');
$pdf->SetCreator('GiBii/Mlia');
$pdf->SetTitle($title);
$pdf->SetDrawColor(200);
$pdf->SetLineWidth(0.1);
$pdf->SetAutoPageBreak(true, 1);

function pdf_ligne_v() {
	// ligne pointille verticale
	global $pdf;
	for ($y=15; $y<280; $y=$y+3) {
		$pdf->Line(105,$y,105,($y+1));	
		}
	}
function pdf_ligne_h($y) {
	// ligne pointille horizontale
	global $pdf;
	for ($x=10; $x<200; $x=$x+3) {
		$pdf->Line($x,$y,($x+1),$y);
		}
	}	
$div = "";
$cpt = 1;

//  planche de  de 8 tiquettes par page -> CHOIX RETENU
for ($i=1; $i<$line_pdf; $i++) {
	$data = $res_pdf[$i];
	//$data[1] c'est le 2 champ de la ligne du CSV : division !
	//Rupture de page si chgt division ou si on en a dj plac 8...	
	if ($div != $data[1]) {
		// Nouvelle page 
		$pdf->AddPage();
		$div = $data[1];
		$cpt = 0;
		}
	else if ( $cpt%8 == 0) {
		// Nouvelle page 
		$pdf->AddPage();	
	   }
	
	$cpt++;
	// En-tete d'tiquette
	$pdf->SetFont('Arial','',7);
	$pdf->Cell(160,3,$etab_nom." - Anne scolaire ".$sess_ascol."-".($sess_ascol+1),'B',0);
	$pdf->SetFont('Arial','B',7);
	$pdf->Cell(30,4,"Classe : ".$data[1],1,1,'C');
	$pdf->SetFont('Arial','B',10);
	$pdf->Cell(150,4,"Validation des Comptences informatiques",0,0,'L');
	$pdf->SetFont('Arial','',7);
	$pdf->Cell(40,4,$mois_pdf,0,1,'R');
	$pdf->SetFont('Arial','B',12);
	$pdf->Cell(190,7,$data[2]." ".$data[3],0,2,'C');
	
	// Test du type de B2i choisi par l'tablissement
	$pdf->SetFont('Arial','',10);
	if (!strpos($etab_niveau, "1") || !strpos($etab_niveau, "2" || !strpos($etab_niveau, "3")))
		$pdf->Cell(190,4,"",0,2);
	if (strpos($etab_niveau, "1"))
		$pdf->Cell(190,4,"B2i cole ".($data[6]==0?"non ":"")."acquis (".$data[5]."% des items valids)",0,2,'C');
	if (strpos($etab_niveau, "2"))
		$pdf->Cell(190,4,"B2i Collge ".($data[8]==0?"non ":"")."acquis (".$data[7]."% des items valids)",0,2,'C');
	if (strpos($etab_niveau, "3"))
		$pdf->Cell(190,4,"B2i Lyce-CFA ".($data[10]==0?"non ":"")."acquis (".$data[9]."% des items valids)",0,2,'C');
	else $pdf->Cell(190,4,"",0,2);
	if (!strpos($etab_niveau, "1") && !strpos($etab_niveau, "2"))
		$pdf->Cell(190,4,"",0,2);
	
	// Ligne pointille horizontale aprs l' tiquette sauf sur la 8
	if ($cpt%8!=0) {
		$pdf->Ln(6);
		$y = ($pdf->GetY()-3);
		pdf_ligne_h($y);
		}
	}	

$pdf->Output($filename,'D');
?>